/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr;

import com.rapid7.client.dcerpc.RPCException;
import com.rapid7.client.dcerpc.dto.ContextHandle;
import com.rapid7.client.dcerpc.dto.SID;
import com.rapid7.client.dcerpc.messages.HandleResponse;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.mssamr.dto.AliasGeneralInformation;
import com.rapid7.client.dcerpc.mssamr.dto.AliasHandle;
import com.rapid7.client.dcerpc.mssamr.dto.DomainDisplayGroup;
import com.rapid7.client.dcerpc.mssamr.dto.DomainHandle;
import com.rapid7.client.dcerpc.mssamr.dto.DomainLockoutInfo;
import com.rapid7.client.dcerpc.mssamr.dto.DomainLogoffInfo;
import com.rapid7.client.dcerpc.mssamr.dto.DomainPasswordInfo;
import com.rapid7.client.dcerpc.mssamr.dto.GroupGeneralInformation;
import com.rapid7.client.dcerpc.mssamr.dto.GroupHandle;
import com.rapid7.client.dcerpc.mssamr.dto.LogonHours;
import com.rapid7.client.dcerpc.mssamr.dto.Membership;
import com.rapid7.client.dcerpc.mssamr.dto.MembershipWithAttributes;
import com.rapid7.client.dcerpc.mssamr.dto.MembershipWithName;
import com.rapid7.client.dcerpc.mssamr.dto.MembershipWithNameAndUse;
import com.rapid7.client.dcerpc.mssamr.dto.MembershipWithUse;
import com.rapid7.client.dcerpc.mssamr.dto.ServerHandle;
import com.rapid7.client.dcerpc.mssamr.dto.UserAllInformation;
import com.rapid7.client.dcerpc.mssamr.dto.UserHandle;
import com.rapid7.client.dcerpc.mssamr.messages.SamrCloseHandleRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrConnect2Request;
import com.rapid7.client.dcerpc.mssamr.messages.SamrEnumerateAliasesInDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrEnumerateDomainsInSamServerRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrEnumerateGroupsInDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrEnumerateResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrEnumerateUsersInDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetAliasMembershipRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetAliasMembershipResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetGroupsForUserRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetGroupsForUserResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetMembersInAliasRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetMembersInGroupRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrGetMembersInGroupResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupDomainInSamServerRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupIdsInDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupIdsInDomainResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupNamesInDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupNamesInDomainResponse;
import com.rapid7.client.dcerpc.mssamr.messages.SamrOpenAliasRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrOpenDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrOpenGroupRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrOpenUserRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryDisplayInformation2Request;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryDisplayInformation2Response;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationAliasRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationDomain2Request;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationDomainRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationGroupRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationUserRequest;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQuerySecurityObjectRequest;
import com.rapid7.client.dcerpc.mssamr.objects.GroupMembership;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRAliasGeneralInformation;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainDisplayGroup;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainDisplayGroupBuffer;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainLockoutInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainLogoffInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainPasswordInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRGroupGeneralInformation;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRLogonHours;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRPSIDArray;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRRIDEnumeration;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRSRSecurityDescriptor;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRUserAllInformation;
import com.rapid7.client.dcerpc.objects.RPCSID;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import com.rapid7.client.dcerpc.service.Service;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.List;

public class SecurityAccountManagerService
extends Service {
    public static final int MAXIMUM_ALLOWED = 0x2000000;

    public SecurityAccountManagerService(RPCTransport transport) {
        super(transport);
    }

    public ServerHandle openServer() throws IOException {
        return this.openServer("");
    }

    public ServerHandle openServer(String serverName) throws IOException {
        return this.openServer(serverName, 0x2000000);
    }

    public ServerHandle openServer(String serverName, int desiredAccess) throws IOException {
        SamrConnect2Request request = new SamrConnect2Request(this.parseWCharNT(serverName), desiredAccess);
        return this.parseServerHandle(this.callExpectSuccess(request, "SamrConnect2"));
    }

    public DomainHandle openDomain(ServerHandle serverHandle, SID domainId) throws IOException {
        return this.openDomain(serverHandle, domainId, 0x2000000);
    }

    public DomainHandle openDomain(ServerHandle serverHandle, SID domainId, int desiredAccess) throws IOException {
        SamrOpenDomainRequest request = new SamrOpenDomainRequest(this.parseHandle(serverHandle), desiredAccess, this.parseSID(domainId));
        return this.parseDomainHandle(this.callExpectSuccess(request, "SamrOpenDomain"));
    }

    public GroupHandle openGroup(DomainHandle domainHandle, long groupRID) throws IOException {
        return this.openGroup(domainHandle, groupRID, 0x2000000);
    }

    public GroupHandle openGroup(DomainHandle domainHandle, long groupRID, int desiredAccess) throws IOException {
        SamrOpenGroupRequest request = new SamrOpenGroupRequest(this.parseHandle(domainHandle), desiredAccess, groupRID);
        return this.parseGroupHandle(this.callExpectSuccess(request, "SamrOpenGroupRequest"));
    }

    public UserHandle openUser(DomainHandle domainHandle, long userRID) throws IOException {
        return this.openUser(domainHandle, userRID, 131355);
    }

    public UserHandle openUser(DomainHandle domainHandle, long userRID, int desiredAccess) throws IOException {
        SamrOpenUserRequest request = new SamrOpenUserRequest(this.parseHandle(domainHandle), desiredAccess, userRID);
        return this.parseUserHandle(this.callExpectSuccess(request, "SamrOpenUserRequest"));
    }

    public AliasHandle openAlias(DomainHandle domainHandle, long aliasRID) throws IOException {
        return this.openAlias(domainHandle, aliasRID, 131084);
    }

    public AliasHandle openAlias(DomainHandle domainHandle, long aliasRID, int desiredAccess) throws IOException {
        SamrOpenAliasRequest request = new SamrOpenAliasRequest(this.parseHandle(domainHandle), desiredAccess, aliasRID);
        return this.parseAliasHandle(this.callExpectSuccess(request, "SamrOpenAlias"));
    }

    public boolean closeHandle(ContextHandle handle) throws IOException {
        SamrCloseHandleRequest request = new SamrCloseHandleRequest(this.parseHandle(handle));
        HandleResponse response = this.call(request);
        if (SystemErrorCode.ERROR_SUCCESS.is(response.getReturnValue())) {
            return true;
        }
        if (SystemErrorCode.STATUS_INVALID_HANDLE.is(response.getReturnValue())) {
            return false;
        }
        throw new RPCException("SamrCloseHandle", response.getReturnValue());
    }

    public MembershipWithName[] getDomainsForServer(ServerHandle serverHandle) throws IOException {
        int bufferSize = 65535;
        return this.getDomainsForServer(serverHandle, 65535);
    }

    public MembershipWithName[] getDomainsForServer(ServerHandle serverHandle, final int bufferSize) throws IOException {
        ArrayList domainInfos = new ArrayList();
        final byte[] serverHandleBytes = this.parseHandle(serverHandle);
        this.enumerate(domainInfos, new EnumerationCallback(){

            @Override
            public String getName() {
                return "SamrEnumerateDomainsInSamServer";
            }

            @Override
            public SamrEnumerateResponse request(int enumContext) throws IOException {
                SamrEnumerateDomainsInSamServerRequest request = new SamrEnumerateDomainsInSamServerRequest(serverHandleBytes, enumContext, bufferSize);
                return (SamrEnumerateResponse)SecurityAccountManagerService.this.call(request);
            }
        });
        return this.parseSAMPRRIDEnumerations(domainInfos);
    }

    public MembershipWithName[] getAliasesForDomain(DomainHandle domainHandle) throws IOException {
        int bufferSize = 65535;
        return this.getAliasesForDomain(domainHandle, 65535);
    }

    public MembershipWithName[] getAliasesForDomain(DomainHandle domainHandle, final int bufferSize) throws IOException {
        ArrayList aliases = new ArrayList();
        final byte[] domainHandleBytes = this.parseHandle(domainHandle);
        this.enumerate(aliases, new EnumerationCallback(){

            @Override
            public String getName() {
                return "SamrEnumerateAliasesInDomain";
            }

            @Override
            public SamrEnumerateResponse request(int enumContext) throws IOException {
                SamrEnumerateAliasesInDomainRequest request = new SamrEnumerateAliasesInDomainRequest(domainHandleBytes, enumContext, bufferSize);
                return (SamrEnumerateResponse)SecurityAccountManagerService.this.call(request);
            }
        });
        return this.parseSAMPRRIDEnumerations(aliases);
    }

    public MembershipWithName[] getGroupsForDomain(DomainHandle domainHandle) throws IOException {
        int bufferSize = 65535;
        return this.getGroupsForDomain(domainHandle, 65535);
    }

    public MembershipWithName[] getGroupsForDomain(DomainHandle domainHandle, final int bufferSize) throws IOException {
        ArrayList groupInfos = new ArrayList();
        final byte[] domainHandleBytes = this.parseHandle(domainHandle);
        this.enumerate(groupInfos, new EnumerationCallback(){

            @Override
            public String getName() {
                return "SamrEnumerateGroupsInDomain";
            }

            @Override
            public SamrEnumerateResponse request(int enumContext) throws IOException {
                SamrEnumerateGroupsInDomainRequest request = new SamrEnumerateGroupsInDomainRequest(domainHandleBytes, enumContext, bufferSize);
                return (SamrEnumerateResponse)SecurityAccountManagerService.this.call(request);
            }
        });
        return this.parseSAMPRRIDEnumerations(groupInfos);
    }

    public MembershipWithName[] getUsersForDomain(DomainHandle domainHandle) throws IOException {
        return this.getUsersForDomain(domainHandle, 0);
    }

    public MembershipWithName[] getUsersForDomain(DomainHandle domainHandle, int userAccountControl) throws IOException {
        int bufferSize = 65535;
        return this.getUsersForDomain(domainHandle, userAccountControl, 65535);
    }

    public MembershipWithName[] getUsersForDomain(DomainHandle domainHandle, final int userAccountControl, final int bufferSize) throws IOException {
        ArrayList userInfos = new ArrayList();
        final byte[] domainHandleBytes = this.parseHandle(domainHandle);
        this.enumerate(userInfos, new EnumerationCallback(){

            @Override
            public String getName() {
                return "SamrEnumerateUsersInDomain";
            }

            @Override
            public SamrEnumerateResponse request(int enumContext) throws IOException {
                SamrEnumerateUsersInDomainRequest request = new SamrEnumerateUsersInDomainRequest(domainHandleBytes, enumContext, userAccountControl, bufferSize);
                return (SamrEnumerateResponse)SecurityAccountManagerService.this.call(request);
            }
        });
        return this.parseSAMPRRIDEnumerations(userInfos);
    }

    public UserAllInformation getUserAllInformation(UserHandle userHandle) throws IOException {
        SamrQueryInformationUserRequest.UserAllInformation request = new SamrQueryInformationUserRequest.UserAllInformation(this.parseHandle(userHandle));
        SAMPRUserAllInformation userInformation = this.callExpectSuccess(request, "SamrQueryInformationUser[21]").getUserInformation();
        if (userInformation == null) {
            return null;
        }
        try {
            return new UserAllInformation(userInformation.getLastLogon(), userInformation.getLastLogoff(), userInformation.getPasswordLastSet(), userInformation.getAccountExpires(), userInformation.getPasswordCanChange(), userInformation.getPasswordMustChange(), this.parseRPCUnicodeString(userInformation.getUserName()), this.parseRPCUnicodeString(userInformation.getFullName()), this.parseRPCUnicodeString(userInformation.getHomeDirectory()), this.parseRPCUnicodeString(userInformation.getHomeDirectoryDrive()), this.parseRPCUnicodeString(userInformation.getScriptPath()), this.parseRPCUnicodeString(userInformation.getProfilePath()), this.parseRPCUnicodeString(userInformation.getAdminComment()), this.parseRPCUnicodeString(userInformation.getWorkStations()), this.parseRPCUnicodeString(userInformation.getUserComment()), this.parseRPCUnicodeString(userInformation.getParameters()), userInformation.getLmOwfPassword().getBuffer(), userInformation.getNtOwfPassword().getBuffer(), userInformation.getPrivateData().getValue(), this.parseSAMPRSRSecurityDescriptor(userInformation.getSecurityDescriptor()), userInformation.getUserId(), userInformation.getPrimaryGroupId(), userInformation.getUserAccountControl(), userInformation.getWhichFields(), this.parseSAMPRLogonHours(userInformation.getLogonHours()), userInformation.getBadPasswordCount(), userInformation.getLogonCount(), userInformation.getCountryCode(), userInformation.getCodePage(), userInformation.getLmPasswordPresent() != '\u0000', userInformation.getNtPasswordPresent() != '\u0000', userInformation.getPasswordExpired() != '\u0000', userInformation.getPrivateDataSensitive() != '\u0000');
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public GroupGeneralInformation getGroupGeneralInformation(GroupHandle groupHandle) throws IOException {
        SamrQueryInformationGroupRequest.GroupGeneralInformation request = new SamrQueryInformationGroupRequest.GroupGeneralInformation(this.parseHandle(groupHandle));
        SAMPRGroupGeneralInformation groupGeneralInformation = this.callExpectSuccess(request, "SamrQueryInformationGroup[1]").getGroupInformation();
        if (groupGeneralInformation == null) {
            return null;
        }
        return new GroupGeneralInformation(this.parseRPCUnicodeString(groupGeneralInformation.getName()), groupGeneralInformation.getAttributes(), groupGeneralInformation.getMemberCount(), this.parseRPCUnicodeString(groupGeneralInformation.getAdminComment()));
    }

    public AliasGeneralInformation getAliasGeneralInformation(AliasHandle aliasHandle) throws IOException {
        SamrQueryInformationAliasRequest.AliasGeneralInformation request = new SamrQueryInformationAliasRequest.AliasGeneralInformation(this.parseHandle(aliasHandle));
        SAMPRAliasGeneralInformation aliasGeneralInformation = this.callExpectSuccess(request, "SamrQueryInformationAlias[1]").getAliasInformation();
        if (aliasGeneralInformation == null) {
            return null;
        }
        return new AliasGeneralInformation(this.parseRPCUnicodeString(aliasGeneralInformation.getName()), aliasGeneralInformation.getMemberCount(), this.parseRPCUnicodeString(aliasGeneralInformation.getAdminComment()));
    }

    public SID[] getMembersInAlias(AliasHandle aliasHandle) throws IOException {
        SamrGetMembersInAliasRequest request = new SamrGetMembersInAliasRequest(this.parseHandle(aliasHandle));
        RPCSID[] rpcsids = this.callExpectSuccess(request, "SamrGetMembersInAlias").getSids();
        return this.parseRPCSIDs(rpcsids);
    }

    public DomainPasswordInfo getDomainPasswordInfo(DomainHandle domainHandle) throws IOException {
        SamrQueryInformationDomainRequest.DomainPasswordInformation request = new SamrQueryInformationDomainRequest.DomainPasswordInformation(this.parseHandle(domainHandle));
        SAMPRDomainPasswordInfo passwordInfo = this.callExpectSuccess(request, "SamrQueryInformationDomain[1]").getDomainInformation();
        if (passwordInfo == null) {
            return null;
        }
        return new DomainPasswordInfo(passwordInfo.getMinPasswordLength(), passwordInfo.getPasswordHistoryLength(), passwordInfo.getPasswordProperties(), passwordInfo.getMaxPasswordAge(), passwordInfo.getMinPasswordAge());
    }

    public DomainLogoffInfo getDomainLogOffInfo(DomainHandle domainHandle) throws IOException {
        SamrQueryInformationDomainRequest.DomainLogOffInformation request = new SamrQueryInformationDomainRequest.DomainLogOffInformation(this.parseHandle(domainHandle));
        SAMPRDomainLogoffInfo samprDomainLogoffInfo = this.callExpectSuccess(request, "SamrQueryInformationDomain[3]").getDomainInformation();
        if (samprDomainLogoffInfo == null) {
            return null;
        }
        return new DomainLogoffInfo(samprDomainLogoffInfo.getForceLogoff());
    }

    public DomainLockoutInfo getDomainLockoutInfo(DomainHandle domainHandle) throws IOException {
        SamrQueryInformationDomain2Request.DomainLockoutInformation request = new SamrQueryInformationDomain2Request.DomainLockoutInformation(this.parseHandle(domainHandle));
        SAMPRDomainLockoutInfo samprDomainLockoutInfo = this.callExpectSuccess(request, "SamrQueryInformationDomain2[12]").getDomainInformation();
        if (samprDomainLockoutInfo == null) {
            return null;
        }
        return new DomainLockoutInfo(samprDomainLockoutInfo.getLockoutDuration(), samprDomainLockoutInfo.getLockoutObservationWindow(), samprDomainLockoutInfo.getLockoutThreshold());
    }

    public DomainDisplayGroup[] getDomainGroupInformationForDomain(DomainHandle domainHandle) throws IOException {
        int entryCount = -1;
        int maxLength = 65535;
        return this.getDomainGroupInformationForDomain(domainHandle, -1, 65535);
    }

    public DomainDisplayGroup[] getDomainGroupInformationForDomain(DomainHandle domainHandle, int entryCount, int maxLength) throws IOException {
        int returnCode;
        SamrQueryDisplayInformation2Response<SAMPRDomainDisplayGroupBuffer> response;
        List buffer;
        byte[] domainHandleBytes = this.parseHandle(domainHandle);
        ArrayList displayGroups = new ArrayList();
        int enumContext = 0;
        int totalReturnedBytes = 0;
        while (true) {
            SamrQueryDisplayInformation2Request.DomainDisplayGroup request;
            if ((buffer = (response = this.call(request = new SamrQueryDisplayInformation2Request.DomainDisplayGroup(domainHandleBytes, enumContext, entryCount, maxLength))).getDisplayInformation().getEntries()) == null) {
                buffer = new ArrayList();
            }
            enumContext += buffer.size();
            totalReturnedBytes += response.getTotalReturned();
            returnCode = response.getReturnValue();
            if (!SystemErrorCode.ERROR_MORE_ENTRIES.is(returnCode)) break;
            displayGroups.addAll(buffer);
        }
        if (!SystemErrorCode.ERROR_NO_MORE_ITEMS.is(returnCode) && !SystemErrorCode.ERROR_SUCCESS.is(returnCode) && totalReturnedBytes != response.getTotalAvailable()) {
            throw new RPCException("QueryDisplayInformation2", returnCode);
        }
        displayGroups.addAll(buffer);
        DomainDisplayGroup[] ret = new DomainDisplayGroup[displayGroups.size()];
        int i = 0;
        for (SAMPRDomainDisplayGroup displayGroup : displayGroups) {
            ret[i++] = new DomainDisplayGroup(displayGroup.getRid(), this.parseRPCUnicodeString(displayGroup.getAccountName()), this.parseRPCUnicodeString(displayGroup.getDescription()), displayGroup.getAttributes());
        }
        return ret;
    }

    public byte[] getSecurityObject(ContextHandle objectHandle) throws IOException {
        return this.getSecurityObject(objectHandle, true, true, true, true);
    }

    public byte[] getSecurityObject(ContextHandle objectHandle, boolean queryOwner, boolean queryGroup, boolean queryDACL, boolean querySACL) throws IOException {
        int securityInformation = 0;
        if (queryOwner) {
            securityInformation |= 1;
        }
        if (queryGroup) {
            securityInformation |= 2;
        }
        if (queryDACL) {
            securityInformation |= 4;
        }
        if (querySACL) {
            securityInformation |= 8;
        }
        SamrQuerySecurityObjectRequest request = new SamrQuerySecurityObjectRequest(this.parseHandle(objectHandle), securityInformation);
        return this.parseSAMPRSRSecurityDescriptor(this.callExpectSuccess(request, "SamrQuerySecurityObject").getSecurityDescriptor());
    }

    public SID getSIDForDomain(ServerHandle serverHandle, String domainName) throws IOException {
        SamrLookupDomainInSamServerRequest request = new SamrLookupDomainInSamServerRequest(this.parseHandle(serverHandle), RPCUnicodeString.NonNullTerminated.of(domainName));
        RPCSID rpcsid = this.callExpectSuccess(request, "SamrLookupDomainInSamServer").getDomainId();
        return this.parseRPCSID(rpcsid);
    }

    public MembershipWithUse[] lookupNamesInDomain(DomainHandle domainHandle, String ... names) throws IOException {
        long[] uses;
        SamrLookupNamesInDomainRequest request = new SamrLookupNamesInDomainRequest(this.parseHandle(domainHandle), this.parseNonNullTerminatedStrings(names));
        SamrLookupNamesInDomainResponse response = this.callExpect(request, "SamrLookupNamesInDomain", SystemErrorCode.ERROR_SUCCESS, SystemErrorCode.STATUS_SOME_NOT_MAPPED, SystemErrorCode.STATUS_NONE_MAPPED);
        long[] relativeIds = response.getRelativeIds().getArray();
        if (relativeIds == null) {
            relativeIds = new long[]{};
        }
        if ((uses = response.getUse().getArray()) == null) {
            uses = new long[]{};
        }
        if (relativeIds.length != uses.length) {
            throw new UnmarshalException(String.format("Expected RelativeIds.length == Uses.length but %d != %d", relativeIds.length, uses.length));
        }
        MembershipWithUse[] memberships = new MembershipWithUse[relativeIds.length];
        for (int i = 0; i < memberships.length; ++i) {
            memberships[i] = relativeIds[i] == 0L ? null : new MembershipWithUse(relativeIds[i], (int)uses[i]);
        }
        return memberships;
    }

    public MembershipWithNameAndUse[] lookupRIDsInDomain(DomainHandle domainHandle, long ... rids) throws IOException {
        SamrLookupIdsInDomainRequest request = new SamrLookupIdsInDomainRequest(this.parseHandle(domainHandle), rids);
        SamrLookupIdsInDomainResponse response = this.callExpect(request, "SamrLookupIdsInDomain", SystemErrorCode.ERROR_SUCCESS, SystemErrorCode.STATUS_SOME_NOT_MAPPED, SystemErrorCode.STATUS_NONE_MAPPED);
        List<RPCUnicodeString.NonNullTerminated> names = response.getNames();
        long[] uses = response.getUses().getArray();
        if (uses == null) {
            uses = new long[]{};
        }
        MembershipWithNameAndUse[] members = new MembershipWithNameAndUse[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String name = this.parseRPCUnicodeString(names.get(i));
            members[i] = name == null ? null : new MembershipWithNameAndUse(rids[i], name, (int)uses[i]);
        }
        return members;
    }

    public MembershipWithAttributes[] getGroupsForUser(UserHandle userHandle) throws IOException {
        SamrGetGroupsForUserRequest request = new SamrGetGroupsForUserRequest(this.parseHandle(userHandle));
        SamrGetGroupsForUserResponse response = this.callExpectSuccess(request, "GetGroupsForUser");
        return this.parseGroupMemberships(response.getGroups());
    }

    public MembershipWithAttributes[] getMembersForGroup(GroupHandle groupHandle) throws IOException {
        SamrGetMembersInGroupRequest request = new SamrGetMembersInGroupRequest(this.parseHandle(groupHandle));
        SamrGetMembersInGroupResponse response = this.callExpectSuccess(request, "GetMembersForGroup");
        return this.parseGroupMemberships(response.getList());
    }

    public Membership[] getAliasMembership(DomainHandle domainHandle, SID ... sids) throws IOException {
        RPCSID[] rpcSids = this.parseSIDs(sids);
        SAMPRPSIDArray sidArray = new SAMPRPSIDArray(rpcSids);
        SamrGetAliasMembershipRequest request = new SamrGetAliasMembershipRequest(this.parseHandle(domainHandle), sidArray);
        SamrGetAliasMembershipResponse response = this.callExpectSuccess(request, "GetAliasMembership");
        long[] rids = response.getMembership().getArray();
        if (rids == null) {
            rids = new long[]{};
        }
        Membership[] ret = new Membership[rids.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Membership(rids[i]);
        }
        return ret;
    }

    private <T> void enumerate(List<T> list, EnumerationCallback callback) throws IOException {
        block3: {
            int returnCode;
            SamrEnumerateResponse response;
            int enumContext = 0;
            while (true) {
                response = callback.request(enumContext);
                returnCode = response.getReturnValue();
                enumContext = response.getResumeHandle();
                List responseList = response.getList();
                if (!SystemErrorCode.ERROR_MORE_ENTRIES.is(returnCode) && !SystemErrorCode.ERROR_NO_MORE_ITEMS.is(returnCode) && !SystemErrorCode.ERROR_SUCCESS.is(returnCode)) break;
                if (responseList != null) {
                    list.addAll(responseList);
                }
                if (SystemErrorCode.ERROR_MORE_ENTRIES.is(returnCode)) {
                    continue;
                }
                break block3;
                break;
            }
            throw new RPCException(response.getClass().getName(), returnCode);
        }
    }

    private ServerHandle parseServerHandle(HandleResponse response) {
        return new ServerHandle(response.getHandle());
    }

    private DomainHandle parseDomainHandle(HandleResponse response) {
        return new DomainHandle(response.getHandle());
    }

    private GroupHandle parseGroupHandle(HandleResponse response) {
        return new GroupHandle(response.getHandle());
    }

    private UserHandle parseUserHandle(HandleResponse response) {
        return new UserHandle(response.getHandle());
    }

    private AliasHandle parseAliasHandle(HandleResponse response) {
        return new AliasHandle(response.getHandle());
    }

    private LogonHours parseSAMPRLogonHours(SAMPRLogonHours logonHours) {
        return new LogonHours(logonHours.getLogonHours());
    }

    private byte[] parseSAMPRSRSecurityDescriptor(SAMPRSRSecurityDescriptor sd) {
        if (sd == null) {
            return null;
        }
        return sd.getSecurityDescriptor();
    }

    private MembershipWithName[] parseSAMPRRIDEnumerations(List<? extends SAMPRRIDEnumeration> list) {
        MembershipWithName[] memberships = new MembershipWithName[list.size()];
        int i = 0;
        for (SAMPRRIDEnumeration sAMPRRIDEnumeration : list) {
            if (sAMPRRIDEnumeration == null) {
                memberships[i++] = null;
                continue;
            }
            memberships[i++] = new MembershipWithName(sAMPRRIDEnumeration.getRelativeId(), sAMPRRIDEnumeration.getName().getValue());
        }
        return memberships;
    }

    private MembershipWithAttributes[] parseGroupMemberships(List<GroupMembership> groupMemberships) {
        if (groupMemberships == null) {
            return new MembershipWithAttributes[0];
        }
        MembershipWithAttributes[] ret = new MembershipWithAttributes[groupMemberships.size()];
        for (int i = 0; i < ret.length; ++i) {
            GroupMembership groupMembership = groupMemberships.get(i);
            ret[i] = groupMembership == null ? null : new MembershipWithAttributes(groupMembership.getRelativeID(), groupMembership.getAttributes());
        }
        return ret;
    }

    private static interface EnumerationCallback {
        public String getName();

        public SamrEnumerateResponse request(int var1) throws IOException;
    }
}

