/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupIdsInDomainResponse;
import java.io.IOException;

public class SamrLookupIdsInDomainRequest
extends RequestCall<SamrLookupIdsInDomainResponse> {
    public static short OP_NUM = (short)18;
    private final byte[] handle;
    private final int count;
    private final long[] relativeIDs;

    public SamrLookupIdsInDomainRequest(byte[] domainHandle, long ... rids) {
        super(OP_NUM);
        this.handle = domainHandle;
        this.count = rids.length;
        if (this.count > 1000) {
            throw new IllegalArgumentException("Count cannot exceed 1000 to limit the amount of memory client can force the server to allocate: " + this.count);
        }
        this.relativeIDs = rids;
    }

    @Override
    public void marshal(PacketOutput out) throws IOException {
        out.write(this.handle);
        out.writeInt(this.count);
        out.writeInt(1000);
        out.writeInt(0);
        out.writeInt(this.count);
        for (long rid : this.relativeIDs) {
            out.writeInt(rid);
        }
    }

    @Override
    public SamrLookupIdsInDomainResponse getResponseObject() {
        return new SamrLookupIdsInDomainResponse();
    }
}

