/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mslsad.objects.DomainInformationClass;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainLockoutInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainLogoffInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainPasswordInfo;
import java.io.IOException;

public abstract class SamrQueryInformationDomainResponse<T extends Unmarshallable>
extends RequestResponse {
    private T domainInformation;

    public T getDomainInformation() {
        return this.domainInformation;
    }

    public abstract DomainInformationClass getDomainInformationClass();

    abstract T createDomainInformation();

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        if (packetIn.readReferentID() != 0) {
            short infoLevel = packetIn.readShort();
            if (infoLevel != this.getDomainInformationClass().getInfoLevel()) {
                throw new IllegalArgumentException(String.format("Incoming DOMAIN_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getDomainInformationClass().getInfoLevel()));
            }
            this.domainInformation = this.createDomainInformation();
            packetIn.readUnmarshallable(this.domainInformation);
        } else {
            this.domainInformation = null;
        }
    }

    public static class DomainLockoutInformation
    extends SamrQueryInformationDomainResponse<SAMPRDomainLockoutInfo> {
        @Override
        public DomainInformationClass getDomainInformationClass() {
            return DomainInformationClass.DOMAIN_LOCKOUT_INFORMATION;
        }

        @Override
        SAMPRDomainLockoutInfo createDomainInformation() {
            return new SAMPRDomainLockoutInfo();
        }
    }

    public static class DomainLogOffInformation
    extends SamrQueryInformationDomainResponse<SAMPRDomainLogoffInfo> {
        @Override
        public DomainInformationClass getDomainInformationClass() {
            return DomainInformationClass.DOMAIN_LOGOFF_INFORMATION;
        }

        @Override
        SAMPRDomainLogoffInfo createDomainInformation() {
            return new SAMPRDomainLogoffInfo();
        }
    }

    public static class DomainPasswordInformation
    extends SamrQueryInformationDomainResponse<SAMPRDomainPasswordInfo> {
        @Override
        public DomainInformationClass getDomainInformationClass() {
            return DomainInformationClass.DOMAIN_PASSWORD_INFORMATION;
        }

        @Override
        SAMPRDomainPasswordInfo createDomainInformation() {
            return new SAMPRDomainPasswordInfo();
        }
    }
}

