/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import java.io.IOException;

public class NetprPathCanonicalizeResponse
extends RequestResponse {
    private String outBuf;
    private int pathType;

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        this.outBuf = this.readChars(packetIn);
        packetIn.align(Alignment.FOUR);
        this.pathType = packetIn.readInt();
    }

    public String getOutBuf() {
        return this.outBuf;
    }

    public int getPathType() {
        return this.pathType;
    }

    private String readChars(PacketInput packetIn) throws IOException {
        int offset;
        int byteCount = packetIn.readInt();
        int charCount = byteCount / 2;
        StringBuilder result = new StringBuilder(charCount);
        for (offset = 0; offset < charCount; ++offset) {
            char currentChar = (char)packetIn.readShort();
            if (currentChar == '\u0000') break;
            result.append(currentChar);
        }
        packetIn.fullySkipBytes((charCount - offset) * 2);
        return result.toString();
    }
}

