/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl;

import com.rapid7.client.dcerpc.RPCException;
import com.rapid7.client.dcerpc.dto.ContextHandle;
import com.rapid7.client.dcerpc.messages.HandleResponse;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.msvcctl.dto.IServiceConfigInfo;
import com.rapid7.client.dcerpc.msvcctl.dto.IServiceStatusInfo;
import com.rapid7.client.dcerpc.msvcctl.dto.ServiceConfigInfo;
import com.rapid7.client.dcerpc.msvcctl.dto.ServiceHandle;
import com.rapid7.client.dcerpc.msvcctl.dto.ServiceManagerHandle;
import com.rapid7.client.dcerpc.msvcctl.dto.ServiceStatusInfo;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceControl;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceError;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceStartType;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceStatusType;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceType;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServicesAcceptedControls;
import com.rapid7.client.dcerpc.msvcctl.messages.RChangeServiceConfigWRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.RCloseServiceHandleRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.RControlServiceRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.ROpenSCManagerWRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.ROpenServiceWRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.RQueryServiceConfigWRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.RQueryServiceConfigWResponse;
import com.rapid7.client.dcerpc.msvcctl.messages.RQueryServiceStatusRequest;
import com.rapid7.client.dcerpc.msvcctl.messages.RQueryServiceStatusResponse;
import com.rapid7.client.dcerpc.msvcctl.messages.RStartServiceWRequest;
import com.rapid7.client.dcerpc.msvcctl.objects.LPQueryServiceConfigW;
import com.rapid7.client.dcerpc.msvcctl.objects.LPServiceStatus;
import com.rapid7.client.dcerpc.service.Service;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;

public class ServiceControlManagerService
extends Service {
    public static final int FULL_ACCESS = 983103;

    public ServiceControlManagerService(RPCTransport transport) {
        super(transport);
    }

    public ServiceManagerHandle openServiceManagerHandle() throws IOException {
        ROpenSCManagerWRequest request = new ROpenSCManagerWRequest(null, null, 983103);
        return new ServiceManagerHandle(this.callExpectSuccess(request, "ROpenSCManagerW").getHandle());
    }

    public boolean closeServiceManagerHandle(ServiceManagerHandle serviceManagerHandle) throws IOException {
        return this.closeHandle(serviceManagerHandle);
    }

    public ServiceHandle openServiceHandle(ServiceManagerHandle serviceManagerHandle, String serviceName) throws IOException {
        ROpenServiceWRequest request = new ROpenServiceWRequest(this.parseHandle(serviceManagerHandle), this.parseWCharNT(serviceName), 983103);
        return new ServiceHandle(this.callExpectSuccess(request, "ROpenServiceWRequest").getHandle());
    }

    public boolean closeServiceHandle(ServiceHandle serviceHandle) throws IOException {
        return this.closeHandle(serviceHandle);
    }

    private boolean closeHandle(ContextHandle handle) throws IOException {
        if (handle == null) {
            return false;
        }
        RCloseServiceHandleRequest request = new RCloseServiceHandleRequest(this.parseHandle(handle));
        HandleResponse response = this.call(request);
        if (SystemErrorCode.ERROR_SUCCESS.is(response.getReturnValue())) {
            return true;
        }
        if (SystemErrorCode.STATUS_INVALID_HANDLE.is(response.getReturnValue())) {
            return false;
        }
        throw new RPCException("RCloseServiceHandle", response.getReturnValue());
    }

    public IServiceStatusInfo controlService(ServiceHandle serviceHandle, ServiceControl action) throws IOException {
        RControlServiceRequest request = new RControlServiceRequest(serviceHandle.getBytes(), action.getValue());
        RQueryServiceStatusResponse response = this.callExpectSuccess(request, "RControlServiceRequest");
        return this.parseLPServiceStatus(response.getLpServiceStatus());
    }

    public void startService(ServiceHandle serviceHandle) throws IOException {
        RStartServiceWRequest request = new RStartServiceWRequest(serviceHandle.getBytes());
        this.callExpectSuccess(request, "RStartServiceW");
    }

    public IServiceStatusInfo stopService(ServiceHandle serviceHandle) throws IOException {
        return this.controlService(serviceHandle, ServiceControl.STOP);
    }

    public IServiceStatusInfo queryService(ServiceHandle serviceHandle) throws IOException {
        RQueryServiceStatusRequest request = new RQueryServiceStatusRequest(serviceHandle.getBytes());
        RQueryServiceStatusResponse response = this.callExpectSuccess(request, "RQueryServiceStatus");
        return this.parseLPServiceStatus(response.getLpServiceStatus());
    }

    public void changeServiceConfig(ServiceHandle serviceHandle, IServiceConfigInfo serviceConfigInfo) throws IOException {
        RChangeServiceConfigWRequest request = new RChangeServiceConfigWRequest(serviceHandle.getBytes(), serviceConfigInfo.getServiceType().getValue(), serviceConfigInfo.getStartType().getValue(), serviceConfigInfo.getErrorControl().getValue(), this.parseWCharNT(serviceConfigInfo.getBinaryPathName()), this.parseWCharNT(serviceConfigInfo.getLoadOrderGroup()), serviceConfigInfo.getTagId(), serviceConfigInfo.getDependencies(), this.parseWCharNT(serviceConfigInfo.getServiceStartName()), serviceConfigInfo.getPassword(), this.parseWCharNT(serviceConfigInfo.getDisplayName()));
        this.callExpectSuccess(request, "RChangeServiceConfigW");
    }

    public IServiceConfigInfo queryServiceConfig(ServiceHandle serviceHandle) throws IOException {
        RQueryServiceConfigWRequest request = new RQueryServiceConfigWRequest(serviceHandle.getBytes(), 8192);
        RQueryServiceConfigWResponse response = this.callExpectSuccess(request, "RQueryServiceConfigW");
        return this.parseLPQueryServiceConfigW(response.getLpServiceConfig());
    }

    private ServiceStatusInfo parseLPServiceStatus(LPServiceStatus response) {
        ServiceType serviceType = ServiceType.fromInt(response.getDwServiceType());
        ServiceStatusType currentState = ServiceStatusType.fromInt(response.getDwCurrentState());
        ServicesAcceptedControls controlsAccepted = ServicesAcceptedControls.fromInt(response.getDwControlsAccepted());
        return new ServiceStatusInfo(serviceType, currentState, controlsAccepted, response.getDwWin32ExitCode(), response.getDwServiceSpecificExitCode(), response.getDwCheckPoint(), response.getDwWaitHint());
    }

    private ServiceConfigInfo parseLPQueryServiceConfigW(LPQueryServiceConfigW response) {
        ServiceType serviceType = ServiceType.fromInt(response.getDwServiceType());
        ServiceStartType serviceStartType = ServiceStartType.fromInt(response.getDwStartType());
        ServiceError serviceError = ServiceError.fromInt(response.getDwErrorControl());
        String binaryPathName = this.parseWChar(response.getLpBinaryPathName());
        String loadOrderGroup = this.parseWChar(response.getLpLoadOrderGroup());
        int tagId = response.getDwTagId();
        String[] dependencies = response.getLpDependencies();
        String serviceStartName = this.parseWChar(response.getLpServiceStartName());
        String displayName = this.parseWChar(response.getLpDisplayName());
        return new ServiceConfigInfo(serviceType, serviceStartType, serviceError, binaryPathName, loadOrderGroup, tagId, dependencies, serviceStartName, displayName, null);
    }
}

