/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.helper.smbj.share;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2Header;
import com.hierynomus.mssmb2.SMB2ImpersonationLevel;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.messages.SMB2CreateRequest;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2IoctlRequest;
import com.hierynomus.mssmb2.messages.SMB2IoctlResponse;
import com.hierynomus.mssmb2.messages.SMB2ReadRequest;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.mssmb2.messages.SMB2WriteRequest;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.io.ArrayByteChunkProvider;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.PipeShare;
import com.rapid7.helper.smbj.io.SMB2SessionMessage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;

public class NamedPipe
extends SMB2SessionMessage
implements Closeable {
    private static final int FSCTL_PIPE_TRANSCEIVE = 1163287;
    private static final EnumSet<NtStatus> IOCTL_SUCCESS = EnumSet.of(NtStatus.STATUS_SUCCESS, NtStatus.STATUS_BUFFER_OVERFLOW);
    private static final EnumSet<NtStatus> READ_SUCCESS = EnumSet.of(NtStatus.STATUS_SUCCESS, NtStatus.STATUS_BUFFER_OVERFLOW, NtStatus.STATUS_END_OF_FILE);
    private static final EnumSet<NtStatus> WRITE_SUCCESS = EnumSet.of(NtStatus.STATUS_SUCCESS);
    private final PipeShare share;
    private final SMB2FileId fileID;
    private final int transactBufferSize;
    private final int readBufferSize;
    private final int writeBufferSize;

    public NamedPipe(Session session, PipeShare share, String name) throws IOException {
        super(session);
        this.share = share;
        SMB2CreateRequest createRequest = new SMB2CreateRequest(session.getConnection().getNegotiatedProtocol().getDialect(), session.getSessionId(), share.getTreeConnect().getTreeId(), SMB2ImpersonationLevel.Impersonation, EnumSet.of(AccessMask.MAXIMUM_ALLOWED), null, EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ, SMB2ShareAccess.FILE_SHARE_WRITE), SMB2CreateDisposition.FILE_OPEN_IF, null, new SmbPath(share.getSmbPath(), name));
        SMB2CreateResponse createResponse = (SMB2CreateResponse)this.sendAndRead((SMB2Packet)createRequest, EnumSet.of(NtStatus.STATUS_SUCCESS));
        this.fileID = createResponse.getFileId();
        this.transactBufferSize = Math.min(session.getConnection().getConfig().getTransactBufferSize(), session.getConnection().getNegotiatedProtocol().getMaxTransactSize());
        this.readBufferSize = Math.min(session.getConnection().getConfig().getReadBufferSize(), session.getConnection().getNegotiatedProtocol().getMaxReadSize());
        this.writeBufferSize = Math.min(session.getConnection().getConfig().getWriteBufferSize(), session.getConnection().getNegotiatedProtocol().getMaxWriteSize());
    }

    public byte[] transact(byte[] inBuffer) throws IOException {
        SMB2IoctlResponse response = this._ioctl(inBuffer);
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream(4096);
        byte[] outData = response.getOutputBuffer();
        try {
            outBuffer.write(outData);
        }
        catch (IOException exception) {
            throw new SMBRuntimeException((Throwable)exception);
        }
        NtStatus status = NtStatus.valueOf((long)((SMB2Header)response.getHeader()).getStatusCode());
        if (status.equals((Object)NtStatus.STATUS_BUFFER_OVERFLOW)) {
            outBuffer.write(this.read());
        }
        return outBuffer.toByteArray();
    }

    public byte[] read() throws IOException {
        SMB2ReadResponse response;
        NtStatus status;
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream(4096);
        do {
            response = this._read();
            byte[] data = response.getData();
            try {
                dataBuffer.write(data);
            }
            catch (IOException exception) {
                throw new SMBRuntimeException((Throwable)exception);
            }
        } while ((status = NtStatus.valueOf((long)((SMB2Header)response.getHeader()).getStatusCode())).equals((Object)NtStatus.STATUS_BUFFER_OVERFLOW));
        return dataBuffer.toByteArray();
    }

    public void write(byte[] buffer) throws IOException {
        this._write(buffer);
    }

    @Override
    public void close() {
        this.share.closeFileId(this.fileID);
    }

    private SMB2IoctlResponse _ioctl(byte[] inBuffer) throws IOException {
        SMB2IoctlRequest ioctlRequest = new SMB2IoctlRequest(this.getDialect(), this.getSessionID(), this.share.getTreeConnect().getTreeId(), 1163287L, this.fileID, (ByteChunkProvider)new ArrayByteChunkProvider(inBuffer, 0, inBuffer.length, 0L), true, this.transactBufferSize);
        SMB2IoctlResponse ioctlResponse = (SMB2IoctlResponse)this.sendAndRead((SMB2Packet)ioctlRequest, IOCTL_SUCCESS);
        return ioctlResponse;
    }

    private SMB2ReadResponse _read() throws IOException {
        SMB2ReadRequest readRequest = new SMB2ReadRequest(this.getDialect(), this.fileID, this.getSessionID(), this.share.getTreeConnect().getTreeId(), 0L, this.readBufferSize);
        SMB2ReadResponse readResponse = (SMB2ReadResponse)this.sendAndRead((SMB2Packet)readRequest, READ_SUCCESS);
        return readResponse;
    }

    private SMB2WriteResponse _write(byte[] buffer) throws IOException {
        SMB2WriteRequest writeRequest = new SMB2WriteRequest(this.getDialect(), this.fileID, this.getSessionID(), this.share.getTreeConnect().getTreeId(), (ByteChunkProvider)new ArrayByteChunkProvider(buffer, 0, buffer.length, 0L), this.writeBufferSize);
        SMB2WriteResponse writeResponse = (SMB2WriteResponse)this.sendAndRead((SMB2Packet)writeRequest, WRITE_SUCCESS);
        return writeResponse;
    }
}

