/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.FileMemberActionError;
import com.dropbox.core.v2.sharing.MemberAccessLevelResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class FileMemberRemoveActionResult {
    public static final FileMemberRemoveActionResult OTHER = new FileMemberRemoveActionResult(Tag.OTHER, null, null);
    private final Tag _tag;
    private final MemberAccessLevelResult successValue;
    private final FileMemberActionError memberErrorValue;

    private FileMemberRemoveActionResult(Tag _tag, MemberAccessLevelResult successValue, FileMemberActionError memberErrorValue) {
        this._tag = _tag;
        this.successValue = successValue;
        this.memberErrorValue = memberErrorValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static FileMemberRemoveActionResult success(MemberAccessLevelResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FileMemberRemoveActionResult(Tag.SUCCESS, value, null);
    }

    public MemberAccessLevelResult getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isMemberError() {
        return this._tag == Tag.MEMBER_ERROR;
    }

    public static FileMemberRemoveActionResult memberError(FileMemberActionError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FileMemberRemoveActionResult(Tag.MEMBER_ERROR, null, value);
    }

    public FileMemberActionError getMemberErrorValue() {
        if (this._tag != Tag.MEMBER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBER_ERROR, but was Tag." + this._tag.name());
        }
        return this.memberErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.memberErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileMemberRemoveActionResult) {
            FileMemberRemoveActionResult other = (FileMemberRemoveActionResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case MEMBER_ERROR: {
                    return this.memberErrorValue == other.memberErrorValue || this.memberErrorValue.equals(other.memberErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<FileMemberRemoveActionResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileMemberRemoveActionResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g.writeStartObject();
                    this.writeTag("success", g);
                    MemberAccessLevelResult.Serializer.INSTANCE.serialize(value.successValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case MEMBER_ERROR: {
                    g.writeStartObject();
                    this.writeTag("member_error", g);
                    g.writeFieldName("member_error");
                    FileMemberActionError.Serializer.INSTANCE.serialize(value.memberErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public FileMemberRemoveActionResult deserialize(JsonParser p) throws IOException, JsonParseException {
            FileMemberRemoveActionResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                MemberAccessLevelResult fieldValue = null;
                fieldValue = MemberAccessLevelResult.Serializer.INSTANCE.deserialize(p, true);
                value = FileMemberRemoveActionResult.success(fieldValue);
            } else if ("member_error".equals(tag)) {
                FileMemberActionError fieldValue = null;
                Serializer.expectField("member_error", p);
                fieldValue = FileMemberActionError.Serializer.INSTANCE.deserialize(p);
                value = FileMemberRemoveActionResult.memberError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        MEMBER_ERROR,
        OTHER;

    }
}

