/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.DeviceSessionArg;
import com.dropbox.core.v2.team.RevokeDesktopClientArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RevokeDeviceSessionArg {
    private final Tag _tag;
    private final DeviceSessionArg webSessionValue;
    private final RevokeDesktopClientArg desktopClientValue;
    private final DeviceSessionArg mobileClientValue;

    private RevokeDeviceSessionArg(Tag _tag, DeviceSessionArg webSessionValue, RevokeDesktopClientArg desktopClientValue, DeviceSessionArg mobileClientValue) {
        this._tag = _tag;
        this.webSessionValue = webSessionValue;
        this.desktopClientValue = desktopClientValue;
        this.mobileClientValue = mobileClientValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isWebSession() {
        return this._tag == Tag.WEB_SESSION;
    }

    public static RevokeDeviceSessionArg webSession(DeviceSessionArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.WEB_SESSION, value, null, null);
    }

    public DeviceSessionArg getWebSessionValue() {
        if (this._tag != Tag.WEB_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.WEB_SESSION, but was Tag." + this._tag.name());
        }
        return this.webSessionValue;
    }

    public boolean isDesktopClient() {
        return this._tag == Tag.DESKTOP_CLIENT;
    }

    public static RevokeDeviceSessionArg desktopClient(RevokeDesktopClientArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.DESKTOP_CLIENT, null, value, null);
    }

    public RevokeDesktopClientArg getDesktopClientValue() {
        if (this._tag != Tag.DESKTOP_CLIENT) {
            throw new IllegalStateException("Invalid tag: required Tag.DESKTOP_CLIENT, but was Tag." + this._tag.name());
        }
        return this.desktopClientValue;
    }

    public boolean isMobileClient() {
        return this._tag == Tag.MOBILE_CLIENT;
    }

    public static RevokeDeviceSessionArg mobileClient(DeviceSessionArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.MOBILE_CLIENT, null, null, value);
    }

    public DeviceSessionArg getMobileClientValue() {
        if (this._tag != Tag.MOBILE_CLIENT) {
            throw new IllegalStateException("Invalid tag: required Tag.MOBILE_CLIENT, but was Tag." + this._tag.name());
        }
        return this.mobileClientValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.webSessionValue, this.desktopClientValue, this.mobileClientValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RevokeDeviceSessionArg) {
            RevokeDeviceSessionArg other = (RevokeDeviceSessionArg)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case WEB_SESSION: {
                    return this.webSessionValue == other.webSessionValue || this.webSessionValue.equals(other.webSessionValue);
                }
                case DESKTOP_CLIENT: {
                    return this.desktopClientValue == other.desktopClientValue || this.desktopClientValue.equals(other.desktopClientValue);
                }
                case MOBILE_CLIENT: {
                    return this.mobileClientValue == other.mobileClientValue || this.mobileClientValue.equals(other.mobileClientValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RevokeDeviceSessionArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RevokeDeviceSessionArg value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case WEB_SESSION: {
                    g.writeStartObject();
                    this.writeTag("web_session", g);
                    DeviceSessionArg.Serializer.INSTANCE.serialize(value.webSessionValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case DESKTOP_CLIENT: {
                    g.writeStartObject();
                    this.writeTag("desktop_client", g);
                    RevokeDesktopClientArg.Serializer.INSTANCE.serialize(value.desktopClientValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case MOBILE_CLIENT: {
                    g.writeStartObject();
                    this.writeTag("mobile_client", g);
                    DeviceSessionArg.Serializer.INSTANCE.serialize(value.mobileClientValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public RevokeDeviceSessionArg deserialize(JsonParser p) throws IOException, JsonParseException {
            RevokeDeviceSessionArg value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("web_session".equals(tag)) {
                DeviceSessionArg fieldValue = null;
                fieldValue = DeviceSessionArg.Serializer.INSTANCE.deserialize(p, true);
                value = RevokeDeviceSessionArg.webSession(fieldValue);
            } else if ("desktop_client".equals(tag)) {
                RevokeDesktopClientArg fieldValue = null;
                fieldValue = RevokeDesktopClientArg.Serializer.INSTANCE.deserialize(p, true);
                value = RevokeDeviceSessionArg.desktopClient(fieldValue);
            } else if ("mobile_client".equals(tag)) {
                DeviceSessionArg fieldValue = null;
                fieldValue = DeviceSessionArg.Serializer.INSTANCE.deserialize(p, true);
                value = RevokeDeviceSessionArg.mobileClient(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        WEB_SESSION,
        DESKTOP_CLIENT,
        MOBILE_CLIENT;

    }
}

