/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum AuthError {
    INVALID_TOKEN,
    NO_OPENID_AUTH,
    OTHER;


    public static class Serializer
    extends UnionSerializer<AuthError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(AuthError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_TOKEN: {
                    g.writeString("invalid_token");
                    break;
                }
                case NO_OPENID_AUTH: {
                    g.writeString("no_openid_auth");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AuthError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            AuthError value = "invalid_token".equals(tag) ? INVALID_TOKEN : ("no_openid_auth".equals(tag) ? NO_OPENID_AUTH : OTHER);
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

