/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.services.server.AbstractSkeleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.WeakHashMap;

public class HessianProxy
implements InvocationHandler {
    private HessianProxyFactory _factory;
    private WeakHashMap<Method, String> _mangleMap = new WeakHashMap();
    private URL _url;

    HessianProxy(HessianProxyFactory factory, URL url) {
        this._factory = factory;
        this._url = url;
    }

    public URL getURL() {
        return this._url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mangleName;
        WeakHashMap<Method, String> weakHashMap = this._mangleMap;
        synchronized (weakHashMap) {
            mangleName = this._mangleMap.get(method);
        }
        if (mangleName == null) {
            String methodName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
                Object value = args[0];
                if (value == null || !Proxy.isProxyClass(value.getClass())) {
                    return new Boolean(false);
                }
                HessianProxy handler = (HessianProxy)Proxy.getInvocationHandler(value);
                return new Boolean(this._url.equals(handler.getURL()));
            }
            if (methodName.equals("hashCode") && params.length == 0) {
                return new Integer(this._url.hashCode());
            }
            if (methodName.equals("getHessianType")) {
                return proxy.getClass().getInterfaces()[0].getName();
            }
            if (methodName.equals("getHessianURL")) {
                return this._url.toString();
            }
            if (methodName.equals("toString") && params.length == 0) {
                return "HessianProxy[" + this._url + "]";
            }
            mangleName = !this._factory.isOverloadEnabled() ? method.getName() : this.mangleName(method);
            WeakHashMap<Method, String> value = this._mangleMap;
            synchronized (value) {
                this._mangleMap.put(method, mangleName);
            }
        }
        InputStream is = null;
        URLConnection conn = null;
        HttpURLConnection httpConn = null;
        try {
            conn = this.sendRequest(mangleName, args);
            if (conn instanceof HttpURLConnection) {
                httpConn = (HttpURLConnection)conn;
                int code = 500;
                try {
                    code = httpConn.getResponseCode();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (code != 200) {
                    StringBuffer sb;
                    block40: {
                        sb = new StringBuffer();
                        try {
                            int ch;
                            is = httpConn.getInputStream();
                            if (is != null) {
                                while ((ch = is.read()) >= 0) {
                                    sb.append((char)ch);
                                }
                                is.close();
                            }
                            if ((is = httpConn.getErrorStream()) != null) {
                                while ((ch = is.read()) >= 0) {
                                    sb.append((char)ch);
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new HessianRuntimeException(String.valueOf(e));
                        }
                        catch (IOException e) {
                            if (is != null) break block40;
                            throw new HessianProtocolException(code + ": " + e, e);
                        }
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw new HessianProtocolException(code + ": " + sb.toString());
                }
            }
            is = conn.getInputStream();
            AbstractHessianInput in = this._factory.getHessianInput(is);
            Object object = in.readReply(method.getReturnType());
            return object;
        }
        catch (HessianProtocolException e) {
            throw new HessianRuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Throwable e) {}
        }
    }

    protected String mangleName(Method method) {
        Class<?>[] param = method.getParameterTypes();
        if (param == null || param.length == 0) {
            return method.getName();
        }
        return AbstractSkeleton.mangleName(method, false);
    }

    protected URLConnection sendRequest(String methodName, Object[] args) throws IOException {
        URLConnection conn = null;
        conn = this._factory.openConnection(this._url);
        if (this._factory.isChunkedPost() && conn instanceof HttpURLConnection) {
            try {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.setChunkedStreamingMode(8192);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        OutputStream os = null;
        try {
            os = conn.getOutputStream();
        }
        catch (Exception e) {
            throw new HessianRuntimeException(e);
        }
        try {
            AbstractHessianOutput out = this._factory.getHessianOutput(os);
            out.call(methodName, args);
            out.flush();
            return conn;
        }
        catch (IOException e) {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
            throw e;
        }
    }
}

