/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractMapDeserializer;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;

public class ClassDeserializer
extends AbstractMapDeserializer {
    public Class getType() {
        return Class.class;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        int ref = in.addRef(null);
        String name = null;
        while (!in.isEnd()) {
            String key = in.readString();
            if (key.equals("name")) {
                name = in.readString();
                continue;
            }
            in.readObject();
        }
        in.readMapEnd();
        Object value = this.create(name);
        in.setRef(ref, value);
        return value;
    }

    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        int ref = in.addRef(null);
        String name = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            if ("name".equals(fieldNames[i])) {
                name = in.readString();
                continue;
            }
            in.readObject();
        }
        Object value = this.create(name);
        in.setRef(ref, value);
        return value;
    }

    Object create(String name) throws IOException {
        if (name == null) {
            throw new IOException("Serialized Class expects name.");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                return Class.forName(name, false, loader);
            }
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

