/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.Hessian2Constants;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;

public class HessianDebugState
implements Hessian2Constants {
    private PrintWriter _dbg;
    private State _state;
    private ArrayList<State> _stateStack = new ArrayList();
    private ArrayList<ObjectDef> _objectDefList = new ArrayList();
    private int _refId;
    private boolean _isNewline = true;
    private boolean _isObject = false;

    public HessianDebugState(PrintWriter dbg) {
        this._dbg = dbg;
        this._state = new InitialState();
    }

    public void next(int ch) throws IOException {
        this._state = this._state.next(ch);
    }

    void pushStack(State state) {
        this._stateStack.add(state);
    }

    State popStack() {
        return this._stateStack.remove(this._stateStack.size() - 1);
    }

    void println() {
        if (!this._isNewline) {
            this._dbg.println();
            this._dbg.flush();
        }
        this._isNewline = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectDef {
        private String _type;
        private ArrayList<String> _fields;

        ObjectDef(String type, ArrayList<String> fields) {
            this._type = type;
            this._fields = fields;
        }

        String getType() {
            return this._type;
        }

        ArrayList<String> getFields() {
            return this._fields;
        }
    }

    class RemoteState
    extends State {
        private static final int TYPE = 0;
        private static final int VALUE = 1;
        private static final int END = 2;
        private int _state;
        private int _major;
        private int _minor;

        RemoteState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    this.println(-1, "remote");
                    if (ch == 116) {
                        this._state = 1;
                        return new StringState((State)this, 't', false);
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    return HessianDebugState.this.popStack().next(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ReplyState
    extends State {
        private static final int MAJOR = 0;
        private static final int MINOR = 1;
        private static final int HEADER = 2;
        private static final int VALUE = 3;
        private static final int END = 4;
        private int _state;
        private int _major;
        private int _minor;

        ReplyState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 116 || ch == 83) {
                        return new RemoteState().next(ch);
                    }
                    this._major = ch;
                    this._state = 1;
                    return this;
                }
                case 1: {
                    this._minor = ch;
                    this._state = 2;
                    this.println(-1, "reply " + this._major + "." + this._minor);
                    return this;
                }
                case 2: {
                    if (ch == 72) {
                        this._state = 3;
                        return new StringState((State)this, 'H', true);
                    }
                    if (ch == 102) {
                        this.println("f: fault");
                        this._state = 4;
                        return new MapState(this, 0);
                    }
                    this._state = 4;
                    return this.nextObject(ch);
                }
                case 3: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 4: {
                    return HessianDebugState.this.popStack().next(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class CallState
    extends State {
        private static final int MAJOR = 0;
        private static final int MINOR = 1;
        private static final int HEADER = 2;
        private static final int VALUE = 3;
        private static final int ARG = 4;
        private int _state;
        private int _major;
        private int _minor;

        CallState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    this._major = ch;
                    this._state = 1;
                    return this;
                }
                case 1: {
                    this._minor = ch;
                    this._state = 2;
                    this.println(-1, "call " + this._major + "." + this._minor);
                    return this;
                }
                case 2: {
                    if (ch == 72) {
                        this._state = 3;
                        return new StringState((State)this, 'H', true);
                    }
                    if (ch == 109) {
                        this._state = 4;
                        return new StringState((State)this, 'm', true);
                    }
                    this.println((char)ch + ": unexpected char");
                    return HessianDebugState.this.popStack();
                }
                case 3: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 4: {
                    if (ch == 122) {
                        return HessianDebugState.this.popStack();
                    }
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ListState
    extends State {
        private static final int TYPE = 0;
        private static final int LENGTH = 1;
        private static final int VALUE = 2;
        private int _refId;
        private int _state;
        private boolean _hasData;

        ListState(State next, int refId) {
            super(next);
            this._refId = refId;
            this._state = 0;
        }

        boolean isShift(Object value) {
            return this._state == 0 || this._state == 1;
        }

        State shift(Object object) {
            if (this._state == 0) {
                this.println();
                this.println("list " + object + "(#" + this._refId + ")");
                this._state = 1;
                return this;
            }
            if (this._state == 1) {
                this._state = 2;
                return this;
            }
            return this;
        }

        int depth() {
            if (this._state <= 1) {
                return this._next.depth();
            }
            return this._next.depth() + 2;
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 116) {
                        return new StringState((State)this, 't', true);
                    }
                    if (ch == 108) {
                        this.println();
                        this.println("list (#" + this._refId + ")");
                        this._state = 1;
                        return new IntegerState(this, "length");
                    }
                    if (ch == 122) {
                        this.println();
                        this.println("list (#" + this._refId + ")");
                        return this._next;
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    if (ch == 122) {
                        return this._next;
                    }
                    if (ch == 108) {
                        return new IntegerState(this, "length");
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    if (ch == 122) {
                        return this._next;
                    }
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ObjectState
    extends State {
        private static final int TYPE = 0;
        private static final int FIELD = 1;
        private int _refId;
        private int _state;
        private ObjectDef _def;
        private int _count;

        ObjectState(State next, int refId) {
            super(next);
            this._refId = refId;
            this._state = 0;
        }

        boolean isShift(Object value) {
            return this._state == 0;
        }

        State shift(Object object) {
            if (this._state == 0) {
                int def = (Integer)object;
                this._def = (ObjectDef)HessianDebugState.this._objectDefList.get(def);
                this.println(this._def.getType() + " object (#" + this._refId + ")");
                this._state = 1;
                if (this._def.getFields().size() == 0) {
                    return this._next;
                }
            }
            return this;
        }

        int depth() {
            if (this._state <= 0) {
                return this._next.depth();
            }
            return this._next.depth() + 2;
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    return this.nextObject(ch);
                }
                case 1: {
                    this.println();
                    this.print(this._def.getFields().get(this._count++) + ": ");
                    if (this._def.getFields().size() <= this._count) {
                        return this._next.nextObject(ch);
                    }
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ObjectDefState
    extends State {
        private static final int TYPE_COUNT = 0;
        private static final int TYPE = 1;
        private static final int COUNT = 2;
        private static final int FIELD = 3;
        private int _refId;
        private int _state;
        private boolean _hasData;
        private int _count;
        private String _type;
        private ArrayList<String> _fields;

        ObjectDefState(State next) {
            super(next);
            this._fields = new ArrayList();
            this._state = 0;
        }

        boolean isShift(Object value) {
            return true;
        }

        State shift(Object object) {
            if (this._state == 0) {
                int length = (Integer)object;
                this._state = 1;
                return new StringState((State)this, 't', length);
            }
            if (this._state == 1) {
                this._type = (String)object;
                this.println("defun " + this._type);
                HessianDebugState.this._objectDefList.add(new ObjectDef(this._type, this._fields));
                this._state = 2;
                return this;
            }
            if (this._state == 2) {
                this._count = (Integer)object;
                this._state = 3;
                if (this._count == 0) {
                    return this._next;
                }
                return this;
            }
            if (this._state == 3) {
                String field = (String)object;
                --this._count;
                this._fields.add(field);
                this.println(field);
                if (this._count == 0) {
                    return this._next;
                }
                return this;
            }
            throw new UnsupportedOperationException();
        }

        int depth() {
            if (this._state <= 1) {
                return this._next.depth();
            }
            return this._next.depth() + 2;
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    return this.nextObject(ch);
                }
                case 1: {
                    return this.nextObject(ch);
                }
                case 2: {
                    return this.nextObject(ch);
                }
                case 3: {
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class MapState
    extends State {
        private static final int TYPE = 0;
        private static final int KEY = 1;
        private static final int VALUE = 2;
        private int _refId;
        private int _state;
        private boolean _hasData;

        MapState(State next, int refId) {
            super(next);
            this._refId = refId;
            this._state = 0;
        }

        boolean isShift(Object value) {
            return this._state == 0;
        }

        State shift(Object object) {
            this.println();
            this.println("map " + object + "(#" + this._refId + ")");
            this._state = 1;
            return this;
        }

        int depth() {
            if (this._state == 0) {
                return this._next.depth();
            }
            return this._next.depth() + 2;
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 116) {
                        return new StringState((State)this, 't', true);
                    }
                    if (ch == 122) {
                        this.println();
                        this.println("map (#" + this._refId + ")");
                        return this._next;
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    if (ch == 122) {
                        if (this._hasData) {
                            this.println("}");
                        }
                        return this._next;
                    }
                    if (this._hasData) {
                        this.println("}");
                    }
                    this.print("{");
                    this._hasData = true;
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    this.print(", ");
                    this._state = 1;
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ByteState
    extends State {
        int _lengthIndex;
        int _length;
        boolean _isLastChunk;

        ByteState(boolean isLastChunk) {
            this._isLastChunk = isLastChunk;
        }

        State next(int ch) {
            if (this._lengthIndex < 2) {
                this._length = 256 * this._length + (ch & 0xFF);
                if (++this._lengthIndex == 2) {
                    if (this._isLastChunk) {
                        this.println("B: " + this._length);
                    } else {
                        this.println("b: " + this._length);
                    }
                }
                if (this._lengthIndex == 2 && this._length == 0 && this._isLastChunk) {
                    return HessianDebugState.this.popStack();
                }
                return this;
            }
            if (this._length == 0) {
                if (ch == 98) {
                    this._isLastChunk = false;
                    this._lengthIndex = 0;
                    return this;
                }
                if (ch == 66) {
                    this._isLastChunk = true;
                    this._lengthIndex = 0;
                    return this;
                }
                this.println(String.valueOf((char)ch) + ": unexpected character");
                return HessianDebugState.this.popStack();
            }
            --this._length;
            if (this._length == 0) {
                return HessianDebugState.this.popStack();
            }
            return this;
        }
    }

    class StringState
    extends State {
        private static final int TOP = 0;
        private static final int UTF_2_1 = 1;
        private static final int UTF_3_1 = 2;
        private static final int UTF_3_2 = 3;
        char _typeCode;
        StringBuilder _value;
        int _lengthIndex;
        int _length;
        boolean _isLastChunk;
        int _utfState;
        char _ch;

        StringState(State next, char typeCode, boolean isLastChunk) {
            super(next);
            this._value = new StringBuilder();
            this._typeCode = typeCode;
            this._isLastChunk = isLastChunk;
        }

        StringState(State next, char typeCode, int length) {
            super(next);
            this._value = new StringBuilder();
            this._typeCode = typeCode;
            this._isLastChunk = true;
            this._length = length;
            this._lengthIndex = 2;
        }

        State next(int ch) {
            if (this._lengthIndex < 2) {
                this._length = 256 * this._length + (ch & 0xFF);
                if (++this._lengthIndex == 2 && this._length == 0 && this._isLastChunk) {
                    if (this._next.isShift(this._value.toString())) {
                        return this._next.shift(this._value.toString());
                    }
                    this.printObject("\"" + this._value + "\"");
                    return this._next;
                }
                return this;
            }
            if (this._length == 0) {
                if (ch == 115 || ch == 120) {
                    this._isLastChunk = false;
                    this._lengthIndex = 0;
                    return this;
                }
                if (ch == 83 || ch == 88) {
                    this._isLastChunk = true;
                    this._lengthIndex = 0;
                    return this;
                }
                this.println(String.valueOf((char)ch) + ": unexpected character");
                return this._next;
            }
            switch (this._utfState) {
                case 0: {
                    if (ch < 128) {
                        --this._length;
                        this._value.append((char)ch);
                        break;
                    }
                    if (ch < 224) {
                        this._ch = (char)((ch & 0x1F) << 6);
                        this._utfState = 1;
                        break;
                    }
                    this._ch = (char)((ch & 0xF) << 12);
                    this._utfState = 2;
                    break;
                }
                case 1: 
                case 3: {
                    this._ch = (char)(this._ch + (ch & 0x3F));
                    this._value.append(this._ch);
                    --this._length;
                    this._utfState = 0;
                    break;
                }
                case 2: {
                    this._ch = (char)(this._ch + (char)((ch & 0x3F) << 6));
                    this._utfState = 3;
                }
            }
            if (this._length == 0) {
                if (this._next.isShift(this._value.toString())) {
                    return this._next.shift(this._value.toString());
                }
                this.printObject("\"" + this._value + "\"");
                return this._next;
            }
            return this;
        }
    }

    class DoubleState
    extends State {
        int _length;
        long _value;

        DoubleState(State next) {
            super(next);
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                Double value = Double.longBitsToDouble(this._value);
                if (this._next.isShift(value)) {
                    return this._next.shift(value);
                }
                this.printObject(value.toString());
                return this._next;
            }
            return this;
        }
    }

    class DateState
    extends State {
        int _length;
        long _value;

        DateState(State next) {
            super(next);
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                Date value = new Date(this._value);
                if (this._next.isShift(value)) {
                    return this._next.shift(value);
                }
                this.printObject(value.toString());
                return this._next;
            }
            return this;
        }
    }

    class LongState
    extends State {
        int _length;
        long _value;

        LongState(State next) {
            super(next);
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                Long value = new Long(this._value);
                if (this._next.isShift(value)) {
                    return this._next.shift(value);
                }
                this.printObject(value.toString() + " (long)");
                return this._next;
            }
            return this;
        }
    }

    class RefState
    extends State {
        String _typeCode;
        int _length;
        int _value;

        RefState(State next, String typeCode) {
            super(next);
            this._typeCode = typeCode;
        }

        RefState(State next, String typeCode, int value, int length) {
            super(next);
            this._typeCode = typeCode;
            this._value = value;
            this._length = length;
        }

        State next(int ch) {
            this._value = 256 * this._value + (ch & 0xFF);
            if (++this._length == 4) {
                Integer value = new Integer(this._value);
                if (this._next.isShift(value)) {
                    return this._next.shift(value);
                }
                this.printObject("ref(#" + value + ")");
                return this._next;
            }
            return this;
        }
    }

    class IntegerState
    extends State {
        String _typeCode;
        int _length;
        int _value;

        IntegerState(State next, String typeCode) {
            super(next);
            this._typeCode = typeCode;
        }

        IntegerState(State next, String typeCode, int value, int length) {
            super(next);
            this._typeCode = typeCode;
            this._value = value;
            this._length = length;
        }

        State next(int ch) {
            this._value = 256 * this._value + (ch & 0xFF);
            if (++this._length == 4) {
                Integer value = new Integer(this._value);
                if (this._next.isShift(value)) {
                    return this._next.shift(value);
                }
                this.printObject(value.toString());
                return this._next;
            }
            return this;
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        State next(int ch) {
            this.println();
            if (ch == 114) {
                HessianDebugState.this.pushStack(this);
                return new ReplyState();
            }
            if (ch == 99) {
                HessianDebugState.this.pushStack(this);
                return new CallState();
            }
            return this.nextObject(ch);
        }
    }

    abstract class State {
        State _next;

        State() {
        }

        State(State next) {
            this._next = next;
        }

        abstract State next(int var1);

        boolean isShift(Object value) {
            return false;
        }

        State shift(Object value) {
            return this;
        }

        int depth() {
            if (this._next != null) {
                return this._next.depth();
            }
            return 0;
        }

        void printIndent(int depth) {
            if (HessianDebugState.this._isNewline) {
                for (int i = 0; i < this.depth() + depth - 1; ++i) {
                    HessianDebugState.this._dbg.print("  ");
                }
            }
        }

        void print(String string) {
            this.print(0, string);
        }

        void print(int depth, String string) {
            this.printIndent(depth);
            HessianDebugState.this._dbg.print(string);
            HessianDebugState.this._isNewline = false;
            HessianDebugState.this._isObject = false;
        }

        void println(String string) {
            this.println(0, string);
        }

        void println(int depth, String string) {
            this.printIndent(depth);
            HessianDebugState.this._dbg.println(string);
            HessianDebugState.this._dbg.flush();
            HessianDebugState.this._isNewline = true;
            HessianDebugState.this._isObject = false;
        }

        void println() {
            if (!HessianDebugState.this._isNewline) {
                HessianDebugState.this._dbg.println();
                HessianDebugState.this._dbg.flush();
            }
            HessianDebugState.this._isNewline = true;
            HessianDebugState.this._isObject = false;
        }

        void printObject(String string) {
            if (HessianDebugState.this._isObject) {
                this.println();
            }
            this.printIndent(0);
            HessianDebugState.this._dbg.print(string);
            HessianDebugState.this._dbg.flush();
            HessianDebugState.this._isNewline = false;
            HessianDebugState.this._isObject = true;
        }

        protected State nextObject(int ch) {
            switch (ch) {
                case -1: {
                    this.println();
                    return this;
                }
                case 78: {
                    if (this.isShift(null)) {
                        return this.shift(null);
                    }
                    this.println(1, "null");
                    return this;
                }
                case 84: {
                    if (this.isShift(Boolean.TRUE)) {
                        return this.shift(Boolean.TRUE);
                    }
                    this.printObject("true");
                    return this;
                }
                case 70: {
                    if (this.isShift(Boolean.FALSE)) {
                        return this.shift(Boolean.FALSE);
                    }
                    this.printObject("false");
                    return this;
                }
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    Integer value = new Integer(ch - 144);
                    if (this.isShift(value)) {
                        return this.shift(value);
                    }
                    this.printObject(value.toString());
                    return this;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    return new IntegerState(this, "int", ch - 200, 3);
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    return new IntegerState(this, "int", ch - 212, 2);
                }
                case 73: {
                    return new IntegerState(this, "int");
                }
                case 82: {
                    return new RefState(this, "Ref");
                }
                case 114: {
                    HessianDebugState.this.pushStack(this);
                    return new RemoteState();
                }
                case 76: {
                    return new LongState(this);
                }
                case 100: {
                    return new DateState(this);
                }
                case 68: {
                    return new DoubleState(this);
                }
                case 0: {
                    this.printObject("\"\"");
                    return this;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return new StringState(this, 'S', ch);
                }
                case 83: 
                case 88: {
                    return new StringState(this, 'S', true);
                }
                case 115: 
                case 120: {
                    return new StringState(this, 'S', false);
                }
                case 66: {
                    HessianDebugState.this.pushStack(this);
                    return new ByteState(true);
                }
                case 98: {
                    HessianDebugState.this.pushStack(this);
                    return new ByteState(false);
                }
                case 77: {
                    return new MapState(this, HessianDebugState.this._refId++);
                }
                case 86: {
                    return new ListState(this, HessianDebugState.this._refId++);
                }
                case 79: {
                    return new ObjectDefState(this);
                }
                case 111: {
                    return new ObjectState(this, HessianDebugState.this._refId++);
                }
                case 32: {
                    return this;
                }
            }
            this.println(String.valueOf((char)ch) + ": unexpected character");
            return this;
        }
    }
}

