/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class StringValueDeserializer
extends AbstractDeserializer {
    private Class _cl;
    private Constructor _constructor;

    public StringValueDeserializer(Class cl) {
        try {
            this._cl = cl;
            this._constructor = cl.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class getType() {
        return this._cl;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        String value = null;
        while (!in.isEnd()) {
            String key = in.readString();
            if (key.equals("value")) {
                value = in.readString();
                continue;
            }
            in.readObject();
        }
        in.readMapEnd();
        return this.create(value);
    }

    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        String value = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            if ("value".equals(fieldNames[i])) {
                value = in.readString();
                continue;
            }
            in.readObject();
        }
        return this.create(value);
    }

    private Object create(String value) throws IOException {
        if (value == null) {
            throw new IOException(this._cl.getName() + " expects name.");
        }
        try {
            return this._constructor.newInstance(value);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

