/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.services.server.AbstractSkeleton;
import com.caucho.services.server.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSkeleton
extends AbstractSkeleton {
    private static final Logger log = Logger.getLogger(HessianSkeleton.class.getName());
    private Object _service;

    public HessianSkeleton(Object service, Class apiClass) {
        super(apiClass);
        if (service == null) {
            service = this;
        }
        this._service = service;
        if (!apiClass.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException("Service " + service + " must be an instance of " + apiClass.getName());
        }
    }

    public void invoke(AbstractHessianInput in, AbstractHessianOutput out) throws Throwable {
        String header;
        ServiceContext context = ServiceContext.getContext();
        in.skipOptionalCall();
        while ((header = in.readHeader()) != null) {
            Object value = in.readObject();
            context.addHeader(header, value);
        }
        String methodName = in.readMethod();
        Method method = this.getMethod(methodName);
        if (method == null) {
            if ("_hessian_getAttribute".equals(methodName)) {
                String attrName = in.readString();
                in.completeCall();
                String value = null;
                if ("java.api.class".equals(attrName)) {
                    value = this.getAPIClassName();
                } else if ("java.home.class".equals(attrName)) {
                    value = this.getHomeClassName();
                } else if ("java.object.class".equals(attrName)) {
                    value = this.getObjectClassName();
                }
                out.startReply();
                out.writeObject(value);
                out.completeReply();
                return;
            }
            if (method == null) {
                out.startReply();
                out.writeFault("NoSuchMethodException", "The service has no method named: " + in.getMethod(), null);
                out.completeReply();
                return;
            }
        }
        Class<?>[] args = method.getParameterTypes();
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = in.readObject(args[i]);
        }
        in.completeCall();
        Object result = null;
        try {
            result = method.invoke(this._service, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
            return;
        }
        out.startReply();
        out.writeObject(result);
        out.completeReply();
    }
}

