/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.JREvaluator;

public class JRBshEvaluator
extends JREvaluator {
    private String bshScript = null;
    private Interpreter interpreter = null;

    public JRBshEvaluator(String bshScript) throws JRException {
        this.bshScript = bshScript;
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            this.interpreter.eval((Reader)new StringReader(bshScript));
        }
        catch (EvalError e) {
            throw new JRException("Error evaluating report expressions BeanShell script.\nMessage : " + e.getMessage() + "\nLine " + e.getErrorLineNumber() + " : " + this.extractLineContent(e));
        }
    }

    public void verify(Collection expressions) throws JRException {
        try {
            this.interpreter.eval("bshEvaluator = createBshEvaluator()");
            if (expressions != null) {
                for (JRExpression expression : expressions) {
                    this.interpreter.eval("bshEvaluator.evaluateOld(" + expression.getId() + ")");
                }
            }
        }
        catch (TargetError te) {
        }
        catch (EvalError e) {
            throw new JRException("Error testing report expressions BeanShell script.\nMessage : " + e.getMessage() + "\nLine " + e.getErrorLineNumber() + " : " + this.extractLineContent(e));
        }
    }

    @Override
    protected void customizedInit(Map pars, Map fldsm, Map varsm) throws JRException {
        try {
            this.interpreter.set("calculator", (Object)this);
            this.interpreter.set("fldsm", (Object)fldsm);
            this.interpreter.set("varsm", (Object)varsm);
            this.interpreter.set("parsm", (Object)pars);
            this.interpreter.eval("bshEvaluator = createBshEvaluator()");
            this.interpreter.eval("bshEvaluator.init(calculator, parsm, fldsm, varsm)");
        }
        catch (EvalError e) {
            throw new JRException("Error initializing report BeanShell calculator.", e);
        }
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluateOld(" + id + ")");
        }
        catch (TargetError te) {
            throw te.getTarget();
        }
        catch (EvalError ee) {
            throw ee;
        }
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluateEstimated(" + id + ")");
        }
        catch (TargetError te) {
            throw te.getTarget();
        }
        catch (EvalError ee) {
            throw ee;
        }
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluate(" + id + ")");
        }
        catch (TargetError te) {
            throw te.getTarget();
        }
        catch (EvalError ee) {
            throw ee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractLineContent(EvalError e) {
        String lineContent = "";
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new StringReader(this.bshScript));
            int lineNumber = e.getErrorLineNumber();
            for (int i = 0; i < lineNumber; ++i) {
                lineContent = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        return lineContent;
    }
}

