/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components;

import java.io.IOException;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeXmlWriter;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.engine.xml.XmlConstantPropertyRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class ComponentsXmlHandler
implements XmlDigesterConfigurer,
ComponentXmlWriter {
    @Override
    public void configureDigester(Digester digester) {
        this.addListRules(digester);
        this.addBarbecueRules(digester);
        this.addBarcode4jRules(digester);
    }

    protected void addListRules(Digester digester) {
        String listPattern = "*/componentElement/list";
        digester.addObjectCreate(listPattern, StandardListComponent.class);
        digester.addSetProperties(listPattern, new String[]{"printOrder"}, new String[0]);
        digester.addRule(listPattern, (Rule)new XmlConstantPropertyRule("printOrder", JRXmlConstants.getPrintOrderMap()));
        String listContentsPattern = listPattern + "/listContents";
        digester.addObjectCreate(listContentsPattern, DesignListContents.class);
        digester.addSetProperties(listContentsPattern);
        digester.addSetNext(listContentsPattern, "setContents");
    }

    protected void addBarbecueRules(Digester digester) {
        String barcodePattern = "*/componentElement/barbecue";
        digester.addObjectCreate(barcodePattern, StandardBarbecueComponent.class);
        digester.addSetProperties(barcodePattern, new String[]{"evaluationTime"}, new String[0]);
        digester.addRule(barcodePattern, (Rule)new XmlConstantPropertyRule("evaluationTime", JRXmlConstants.getEvaluationTimeMap()));
        String barcodeExpressionPattern = barcodePattern + "/codeExpression";
        digester.addFactoryCreate(barcodeExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(barcodeExpressionPattern, "setText", 0);
        digester.addSetNext(barcodeExpressionPattern, "setCodeExpression", JRExpression.class.getName());
        String applicationIdentifierExpressionPattern = barcodePattern + "/applicationIdentifierExpression";
        digester.addFactoryCreate(applicationIdentifierExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(applicationIdentifierExpressionPattern, "setText", 0);
        digester.addSetNext(applicationIdentifierExpressionPattern, "setApplicationIdentifierExpression", JRExpression.class.getName());
    }

    protected void addBarcode4jRules(Digester digester) {
        this.addBaseBarcode4jRules(digester, "*/componentElement/Codabar", CodabarComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Code128", Code128Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN128", EAN128Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/DataMatrix", DataMatrixComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/RoyalMailCustomer", RoyalMailCustomerComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/USPSIntelligentMail", USPSIntelligentMailComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Code39", Code39Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Interleaved2Of5", Interleaved2Of5Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/UPCA", UPCAComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/UPCE", UPCEComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN13", EAN13Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN8", EAN8Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/POSTNET", POSTNETComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/PDF417", PDF417Component.class);
    }

    protected void addBaseBarcode4jRules(Digester digester, String barcodePattern, Class barcodeComponentClass) {
        digester.addObjectCreate(barcodePattern, barcodeComponentClass);
        digester.addSetProperties(barcodePattern, new String[]{"evaluationTime"}, new String[0]);
        digester.addRule(barcodePattern, (Rule)new XmlConstantPropertyRule("evaluationTime", JRXmlConstants.getEvaluationTimeMap()));
        String codeExpressionPattern = barcodePattern + "/codeExpression";
        digester.addFactoryCreate(codeExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(codeExpressionPattern, "setText", 0);
        digester.addSetNext(codeExpressionPattern, "setCodeExpression", JRExpression.class.getName());
        String patternExpressionPattern = barcodePattern + "/patternExpression";
        digester.addFactoryCreate(patternExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(patternExpressionPattern, "setText", 0);
        digester.addSetNext(patternExpressionPattern, "setPatternExpression", JRExpression.class.getName());
    }

    @Override
    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        if (component instanceof ListComponent) {
            ListComponent list = (ListComponent)component;
            this.writeList(list, componentKey, reportWriter);
        } else if (component instanceof BarbecueComponent) {
            BarbecueComponent barcode = (BarbecueComponent)component;
            this.writeBarbecue(barcode, componentKey, reportWriter);
        } else if (component instanceof BarcodeComponent) {
            BarcodeComponent barcode = (BarcodeComponent)component;
            BarcodeXmlWriter barcodeWriter = new BarcodeXmlWriter(reportWriter, barcode, componentKey);
            barcodeWriter.writeBarcode();
        }
    }

    protected void writeList(ListComponent list, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("list", namespace);
        writer.addAttribute("printOrder", list.getPrintOrder(), JRXmlConstants.getPrintOrderMap());
        writer.addAttribute("ignoreWidth", list.getIgnoreWidth());
        reportWriter.writeDatasetRun(list.getDatasetRun());
        ListContents contents = list.getContents();
        writer.startElement("listContents");
        writer.addAttribute("height", contents.getHeight());
        writer.addAttribute("width", contents.getWidth());
        reportWriter.writeChildElements(contents);
        writer.closeElement();
        writer.closeElement();
    }

    protected void writeBarbecue(BarbecueComponent barcode, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("barbecue", namespace);
        writer.addAttribute("type", barcode.getType());
        writer.addAttribute("drawText", barcode.isDrawText());
        writer.addAttribute("checksumRequired", barcode.isChecksumRequired());
        writer.addAttribute("barWidth", barcode.getBarWidth());
        writer.addAttribute("barHeight", barcode.getBarHeight());
        if (barcode.getEvaluationTime() != 1) {
            writer.addAttribute("evaluationTime", barcode.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap());
        }
        writer.addAttribute("evaluationGroup", barcode.getEvaluationGroup());
        writer.writeExpression("codeExpression", barcode.getCodeExpression(), false);
        writer.writeExpression("applicationIdentifierExpression", barcode.getApplicationIdentifierExpression(), false);
        writer.closeElement();
    }
}

