/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;

public class BarbecueCompiler
implements ComponentCompiler {
    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        BarbecueComponent barcode = (BarbecueComponent)component;
        collector.addExpression(barcode.getCodeExpression());
        collector.addExpression(barcode.getApplicationIdentifierExpression());
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        BarbecueComponent barcode = (BarbecueComponent)component;
        StandardBarbecueComponent compiledBarcode = new StandardBarbecueComponent(barcode, baseFactory);
        return compiledBarcode;
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        byte evaluationTime;
        JRExpression codeExpression;
        BarbecueComponent barcode = (BarbecueComponent)component;
        String type = barcode.getType();
        if (type == null) {
            verifier.addBrokenRule("No barcode type set", (Object)barcode);
        }
        if ((codeExpression = barcode.getCodeExpression()) == null) {
            verifier.addBrokenRule("Barcode expression is null", (Object)barcode);
        } else {
            String valueClass = codeExpression.getValueClassName();
            if (valueClass == null) {
                verifier.addBrokenRule("Barcode expression value class not set", (Object)codeExpression);
            } else if (!"java.lang.String".equals(valueClass)) {
                verifier.addBrokenRule("Class " + valueClass + " not supported for barcode expression. Use java.lang.String instead.", (Object)codeExpression);
            }
        }
        JRExpression applicationIdentifierExpression = barcode.getApplicationIdentifierExpression();
        if (applicationIdentifierExpression != null) {
            String valueClass = applicationIdentifierExpression.getValueClassName();
            if (valueClass == null) {
                verifier.addBrokenRule("Barcode application identifier expression value class not set", (Object)applicationIdentifierExpression);
            } else if (!"java.lang.String".equals(valueClass)) {
                verifier.addBrokenRule("Class " + valueClass + " not supported for barcode application identifier expression. Use java.lang.String instead.", (Object)applicationIdentifierExpression);
            }
        }
        if ((evaluationTime = barcode.getEvaluationTime()) == 7) {
            verifier.addBrokenRule("Auto evaluation time is not supported for barcodes", (Object)barcode);
        } else if (evaluationTime == 5) {
            String evaluationGroup = barcode.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for barcode", (Object)barcode);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Barcode evalution group \"" + evaluationGroup + " not found", (Object)barcode);
            }
        }
    }
}

