/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.BarbecueRenderer;
import net.sf.jasperreports.components.barbecue.BarcodeInfo;
import net.sf.jasperreports.components.barbecue.BarcodeProviders;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sourceforge.barbecue.Barcode;

public class BarbecueFillComponent
extends BaseFillComponent {
    private final BarbecueComponent barcodeComponent;
    private final Map printTemplates = new HashMap();
    private String code;
    private String applicationIdentifier;

    public BarbecueFillComponent(BarbecueComponent barcode) {
        this.barcodeComponent = barcode;
    }

    protected BarbecueComponent getBarcode() {
        return this.barcodeComponent;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateBarcode(evaluation);
        }
    }

    protected void evaluateBarcode(byte evaluation) throws JRException {
        this.code = (String)this.fillContext.evaluate(this.barcodeComponent.getCodeExpression(), evaluation);
        this.applicationIdentifier = (String)this.fillContext.evaluate(this.barcodeComponent.getApplicationIdentifierExpression(), evaluation);
    }

    protected boolean isEvaluateNow() {
        return this.barcodeComponent.getEvaluationTime() == 1;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return this.isEvaluateNow() && this.code == null ? FillPrepareResult.NO_PRINT_NO_OVERFLOW : FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRTemplateImage templateImage = this.getTemplateImage();
        JRTemplatePrintImage image = new JRTemplatePrintImage(templateImage);
        JRComponentElement element = this.fillContext.getComponentElement();
        image.setX(element.getX());
        image.setY(this.fillContext.getElementPrintY());
        image.setWidth(element.getWidth());
        image.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.setBarcodeImage(image);
        } else {
            this.fillContext.registerDelayedEvaluation(image, this.barcodeComponent.getEvaluationTime(), this.barcodeComponent.getEvaluationGroup());
        }
        return image;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateBarcode(evaluation);
        this.setBarcodeImage((JRTemplatePrintImage)element);
    }

    protected void setBarcodeImage(JRTemplatePrintImage image) {
        BarcodeInfo barcodeInfo = new BarcodeInfo();
        barcodeInfo.setType(this.barcodeComponent.getType());
        barcodeInfo.setCode(this.code);
        barcodeInfo.setApplicationIdentifier(this.applicationIdentifier);
        barcodeInfo.setDrawText(this.barcodeComponent.isDrawText());
        barcodeInfo.setRequiresChecksum(this.barcodeComponent.isChecksumRequired());
        barcodeInfo.setBarWidth(this.barcodeComponent.getBarWidth());
        barcodeInfo.setBarHeight(this.barcodeComponent.getBarHeight());
        Barcode barcode = BarcodeProviders.createBarcode(barcodeInfo);
        BarbecueRenderer renderer = new BarbecueRenderer(barcode);
        image.setRenderer(renderer);
    }

    protected JRTemplateImage getTemplateImage() {
        JRStyle elementStyle = this.fillContext.getElementStyle();
        JRTemplateImage templateImage = (JRTemplateImage)this.printTemplates.get(elementStyle);
        if (templateImage == null) {
            templateImage = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            templateImage.setStyle(elementStyle);
            templateImage.setScaleImage((byte)3);
            this.printTemplates.put(elementStyle, templateImage);
        }
        return templateImage;
    }
}

