/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.components.barcode4j.BarcodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeRasterizedImageProducer
implements BarcodeImageProducer {
    public static final String PROPERTY_RESOLUTION = "net.sf.jasperreports.components.barcode4j.image.resolution";
    public static final String PROPERTY_GRAY = "net.sf.jasperreports.components.barcode4j.image.gray";
    public static final String PROPERTY_ANTIALIAS = "net.sf.jasperreports.components.barcode4j.image.antiAlias";

    @Override
    public JRRenderable createImage(JRComponentElement componentElement, BarcodeGenerator barcode, String message, int orientation) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int resolution = JRProperties.getIntegerProperty(componentElement, PROPERTY_RESOLUTION, 300);
            boolean gray = JRProperties.getBooleanProperty(componentElement, PROPERTY_GRAY, true);
            boolean antiAlias = JRProperties.getBooleanProperty(componentElement, PROPERTY_ANTIALIAS, true);
            int imageType = gray ? 10 : 12;
            BitmapCanvasProvider provider = new BitmapCanvasProvider((OutputStream)out, "image/x-png", resolution, imageType, antiAlias, orientation);
            barcode.generateBarcode((CanvasProvider)provider, message);
            provider.finish();
            byte[] imageData = out.toByteArray();
            return JRImageRenderer.getInstance(imageData);
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
    }
}

