/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;

public class ListComponentCompiler
implements ComponentCompiler {
    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        collector.collect(datasetRun);
        JRExpressionCollector datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
        JRElement[] elements = listComponent.getContents().getElements();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                elements[i].collectExpressions(datasetCollector);
            }
        }
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        ListComponent listComponent = (ListComponent)component;
        StandardListComponent compiledComponent = new StandardListComponent(listComponent, baseFactory);
        return compiledComponent;
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        if (datasetRun == null) {
            verifier.addBrokenRule("No list subdataset run set", (Object)listComponent);
        } else {
            verifier.verifyDatasetRun(datasetRun);
        }
        ListContents listContents = listComponent.getContents();
        if (listContents == null) {
            verifier.addBrokenRule("No list contents set", (Object)listComponent);
        } else {
            JRElement[] elements;
            int contentsWidth;
            boolean ignoreWidth;
            Byte listPrintOrder = listComponent.getPrintOrder();
            byte printOder = listPrintOrder == null ? (byte)1 : listPrintOrder;
            Boolean listIgnoreWidth = listComponent.getIgnoreWidth();
            boolean bl = ignoreWidth = listIgnoreWidth != null && listIgnoreWidth != false;
            if (listContents.getHeight() < 0) {
                verifier.addBrokenRule("List contents height must be positive.", (Object)listContents);
            }
            int elementWidth = verifier.getCurrentComponentElement().getWidth();
            Integer width = listContents.getWidth();
            if (width == null) {
                contentsWidth = elementWidth;
                if (printOder == 2) {
                    verifier.addBrokenRule("List contents width must be set for horizontal lists", (Object)listContents);
                }
            } else {
                contentsWidth = width;
                if (width <= 0) {
                    verifier.addBrokenRule("List contents width must be positive.", (Object)listContents);
                }
                if (!ignoreWidth && printOder == 2 && width > elementWidth) {
                    verifier.addBrokenRule("List contents width is larger than the list element width", (Object)listComponent);
                }
            }
            if ((elements = listContents.getElements()) != null) {
                for (int i = 0; i < elements.length; ++i) {
                    JRElement element = elements[i];
                    verifier.verifyElement(element);
                    if (element.getX() < 0 || element.getY() < 0) {
                        verifier.addBrokenRule("Element must be placed at positive coordinates.", (Object)element);
                    }
                    if (element.getY() + element.getHeight() > listContents.getHeight()) {
                        verifier.addBrokenRule("Element reaches outside list contents height: y = " + element.getY() + ", height = " + element.getHeight() + ", list contents height = " + listContents.getHeight() + ".", (Object)element);
                    }
                    if (element.getX() + element.getWidth() <= contentsWidth) continue;
                    verifier.addBrokenRule("Element reaches outside list contents width: x = " + element.getX() + ", width = " + element.getWidth() + ", list contents width = " + contentsWidth + ".", (Object)element);
                }
            }
        }
    }
}

