/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDistinctCountExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;

public class MeasureDefinition {
    protected final byte calculation;
    protected final JRExtendedIncrementerFactory incrementerFactory;
    protected final Class valueClass;
    protected final boolean isSystemDefined;
    protected static final AbstractValueProvider VALUE_PROVIDER = new AbstractValueProvider(){

        @Override
        public Object getValue(JRCalculable calculable) {
            return calculable.getValue();
        }
    };

    public MeasureDefinition(Class valueClass, byte calculation, JRExtendedIncrementerFactory incrementerFactory) {
        this(valueClass, calculation, incrementerFactory, false);
    }

    protected MeasureDefinition(Class valueClass, byte calculation, JRExtendedIncrementerFactory incrementerFactory, boolean isSystemDefined) {
        this.valueClass = valueClass;
        this.calculation = calculation;
        this.incrementerFactory = incrementerFactory;
        this.isSystemDefined = isSystemDefined;
    }

    public static MeasureDefinition createHelperMeasure(MeasureDefinition measure, byte helperCalculation) {
        return new MeasureDefinition(measure.valueClass, helperCalculation, measure.incrementerFactory, true);
    }

    public static MeasureDefinition createDistinctCountHelperMeasure(MeasureDefinition measure) {
        return new MeasureDefinition(measure.valueClass, 0, JRDistinctCountExtendedIncrementerFactory.getInstance(), true);
    }

    public byte getCalculation() {
        return this.calculation;
    }

    public JRExtendedIncrementerFactory getIncrementerFactory() {
        return this.incrementerFactory;
    }

    public JRExtendedIncrementer getIncrementer() {
        return this.incrementerFactory.getExtendedIncrementer(this.calculation);
    }

    protected boolean isSystemDefined() {
        return this.isSystemDefined;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public class MeasureValue
    implements JRCalculable {
        private Object value = null;
        private MeasureValue[] helpers = new MeasureValue[3];
        private boolean initialized;
        private JRExtendedIncrementer incrementer;

        public MeasureValue() {
            this.incrementer = MeasureDefinition.this.getIncrementer();
            this.init();
        }

        protected void init() {
            this.value = this.incrementer.initialValue();
            this.setInitialized(true);
        }

        public void addValue(Object addValue) throws JRException {
            if (addValue != null || !this.incrementer.ignoresNullValues()) {
                this.value = this.incrementer.increment(this, addValue, VALUE_PROVIDER);
                this.setInitialized(false);
            }
        }

        public void addValue(MeasureValue measureValue) throws JRException {
            if (!measureValue.isInitialized()) {
                this.value = this.incrementer.combine(this, measureValue, VALUE_PROVIDER);
                this.setInitialized(false);
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.getValue());
        }

        public MeasureValue setHelper(MeasureValue helperVariable, byte type) {
            MeasureValue old = this.helpers[type];
            this.helpers[type] = helperVariable;
            return old;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public Object getIncrementedValue() {
            return this.value;
        }

        @Override
        public JRCalculable getHelperVariable(byte helperType) {
            return this.helpers[helperType];
        }

        @Override
        public void setInitialized(boolean isInitialized) {
            this.initialized = isInitialized;
        }
    }
}

