/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRImageLoader;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public byte getImageType() {
        return 3;
    }

    @Override
    public Dimension2D getDimension() {
        return null;
    }

    public Color getBackcolor() {
        return null;
    }

    @Override
    public byte[] getImageData() throws JRException {
        Dimension2D dimension = this.getDimension();
        if (dimension != null) {
            byte imageType = this.getImageType();
            BufferedImage bi = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), imageType == 1 || imageType == 3 ? 2 : 1);
            Graphics2D g = this.createGraphics(bi);
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g.setColor(backcolor);
                g.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(g, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
            g.dispose();
            return JRImageLoader.loadImageDataFromAWTImage(bi, this.getImageType());
        }
        return null;
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return bi.createGraphics();
    }
}

