/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;

public class JRWrappingSvgRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 10200L;
    private JRRenderable renderer = null;
    private Dimension2D elementDimension = null;
    private Color backcolor = null;

    public JRWrappingSvgRenderer(JRRenderable renderer, Dimension2D elementDimension, Color backcolor) {
        this.renderer = renderer;
        this.elementDimension = elementDimension;
        this.backcolor = backcolor;
    }

    @Override
    public Dimension2D getDimension() {
        Dimension2D imageDimension = null;
        try {
            imageDimension = this.renderer.getDimension();
        }
        catch (JRException jRException) {
            // empty catch block
        }
        if (imageDimension == null) {
            imageDimension = this.elementDimension;
        }
        return imageDimension;
    }

    @Override
    public Color getBackcolor() {
        return this.backcolor;
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.renderer.render(grx, rectangle);
    }

    @Override
    protected Graphics2D createGraphics(BufferedImage bi) {
        if (this.renderer instanceof JRAbstractSvgRenderer) {
            return ((JRAbstractSvgRenderer)this.renderer).createGraphics(bi);
        }
        return super.createGraphics(bi);
    }
}

