/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRBaseBand
extends JRBaseElementGroup
implements JRBand,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_SPLIT_ALLOWED = "splitAllowed";
    public static final String PROPERTY_SPLIT_TYPE = "splitType";
    protected int height = 0;
    protected Byte splitType = null;
    protected JRExpression printWhenExpression = null;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 30502;
    private boolean isSplitAllowed = true;

    protected JRBaseBand(JRBand band, JRBaseObjectFactory factory) {
        super(band, factory);
        this.height = band.getHeight();
        this.splitType = band.getSplitType();
        this.printWhenExpression = factory.getExpression(band.getPrintWhenExpression());
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isSplitAllowed() {
        return !JRBand.SPLIT_TYPE_PREVENT.equals(this.getSplitType());
    }

    @Override
    public void setSplitAllowed(boolean isSplitAllowed) {
        this.setSplitType(isSplitAllowed ? JRBand.SPLIT_TYPE_STRETCH : JRBand.SPLIT_TYPE_PREVENT);
    }

    @Override
    public Byte getSplitType() {
        return this.splitType;
    }

    @Override
    public void setSplitType(Byte splitType) {
        Byte old = this.splitType;
        this.splitType = splitType;
        this.getEventSupport().firePropertyChange(PROPERTY_SPLIT_TYPE, old, this.splitType);
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public Object clone() {
        JRBaseBand clone = (JRBaseBand)super.clone();
        if (this.printWhenExpression != null) {
            clone.printWhenExpression = (JRExpression)this.printWhenExpression.clone();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseBand jRBaseBand = this;
        synchronized (jRBaseBand) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30502) {
            this.splitType = this.isSplitAllowed ? JRBand.SPLIT_TYPE_STRETCH : JRBand.SPLIT_TYPE_PREVENT;
        }
    }
}

