/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseGenericElement
extends JRBaseElement
implements JRGenericElement {
    private static final long serialVersionUID = 10200L;
    private JRGenericElementType genericType;
    private List parameters;
    private byte evaluationTime = 1;
    private String evaluationGroupName;

    public JRBaseGenericElement(JRGenericElement element, JRBaseObjectFactory factory) {
        super(element, factory);
        this.genericType = element.getGenericType();
        this.evaluationTime = element.getEvaluationTime();
        this.evaluationGroupName = element.getEvaluationGroupName();
        JRGenericElementParameter[] elementParameters = element.getParameters();
        this.parameters = new ArrayList(elementParameters.length);
        for (int i = 0; i < elementParameters.length; ++i) {
            JRGenericElementParameter elementParameter = elementParameters[i];
            JRGenericElementParameter parameter = factory.getGenericElementParameter(elementParameter);
            this.parameters.add(parameter);
        }
    }

    @Override
    public JRGenericElementType getGenericType() {
        return this.genericType;
    }

    @Override
    public JRGenericElementParameter[] getParameters() {
        return this.parameters.toArray(new JRGenericElementParameter[this.parameters.size()]);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    @Override
    public String getEvaluationGroupName() {
        return this.evaluationGroupName;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }
}

