/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseGraphicElement
extends JRBaseElement
implements JRGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen;
    protected Byte fill;
    private Byte pen;

    protected JRBaseGraphicElement(JRGraphicElement graphicElement, JRBaseObjectFactory factory) {
        super(graphicElement, factory);
        this.linePen = graphicElement.getLinePen().clone(this);
        this.fill = graphicElement.getOwnFill();
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public byte getPen() {
        return JRPenUtil.getPenFromLinePen(this.linePen);
    }

    @Override
    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    @Override
    public void setPen(byte pen) {
        this.setPen(new Byte(pen));
    }

    @Override
    public void setPen(Byte pen) {
        JRPenUtil.setLinePenFromPen(pen, this.linePen);
    }

    @Override
    public byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    @Override
    public Byte getOwnFill() {
        return this.fill;
    }

    @Override
    public void setFill(byte fill) {
        this.setFill(new Byte(fill));
    }

    @Override
    public void setFill(Byte fill) {
        Byte old = this.fill;
        this.fill = fill;
        this.getEventSupport().firePropertyChange("fill", old, this.fill);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRBaseGraphicElement clone = (JRBaseGraphicElement)super.clone();
        clone.linePen = this.linePen.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

