/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBasePen
implements JRPen,
Serializable,
Cloneable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LINE_WIDTH = "lineWidth";
    public static final String PROPERTY_LINE_STYLE = "lineStyle";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    protected JRPenContainer penContainer = null;
    protected Float lineWidth = null;
    protected Byte lineStyle = null;
    protected Color lineColor = null;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBasePen(JRPenContainer penContainer) {
        this.penContainer = penContainer;
    }

    @Override
    public JRStyleContainer getStyleContainer() {
        return this.penContainer;
    }

    @Override
    public Float getLineWidth() {
        return JRStyleResolver.getLineWidth(this, this.penContainer.getDefaultLineWidth());
    }

    @Override
    public Float getOwnLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.setLineWidth(new Float(lineWidth));
    }

    @Override
    public void setLineWidth(Float lineWidth) {
        Float old = this.lineWidth;
        this.lineWidth = lineWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_WIDTH, old, this.lineWidth);
    }

    @Override
    public Byte getLineStyle() {
        return JRStyleResolver.getLineStyle(this);
    }

    @Override
    public Byte getOwnLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(byte lineStyle) {
        this.setLineStyle(new Byte(lineStyle));
    }

    @Override
    public void setLineStyle(Byte lineStyle) {
        Byte old = this.lineStyle;
        this.lineStyle = lineStyle;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_STYLE, old, this.lineStyle);
    }

    @Override
    public Color getLineColor() {
        return JRStyleResolver.getLineColor(this, this.penContainer.getDefaultLineColor());
    }

    @Override
    public Color getOwnLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        Color old = this.lineColor;
        this.lineColor = lineColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_COLOR, old, this.lineColor);
    }

    public String getStyleNameReference() {
        return null;
    }

    @Override
    public JRPen clone(JRPenContainer penContainer) {
        JRBasePen clone = null;
        try {
            clone = (JRBasePen)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.penContainer = penContainer;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePen jRBasePen = this;
        synchronized (jRBasePen) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

