/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBasePrintGraphicElement
extends JRBasePrintElement
implements JRPrintGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen = new JRBasePen(this);
    protected Byte fill = null;
    private Byte pen;

    public JRBasePrintGraphicElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    public void copyPen(JRPen linePen) {
        this.linePen = linePen.clone(this);
    }

    @Override
    public byte getPen() {
        return JRPenUtil.getPenFromLinePen(this.linePen);
    }

    @Override
    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    @Override
    public void setPen(byte pen) {
        this.setPen(new Byte(pen));
    }

    @Override
    public void setPen(Byte pen) {
        JRPenUtil.setLinePenFromPen(pen, this.linePen);
    }

    @Override
    public byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    @Override
    public Byte getOwnFill() {
        return this.fill;
    }

    @Override
    public void setFill(byte fill) {
        this.fill = new Byte(fill);
    }

    @Override
    public void setFill(Byte fill) {
        this.fill = fill;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

