/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseStyle
implements JRStyle,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10001L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BLANK_WHEN_NULL = "blankWhenNull";
    public static final String PROPERTY_BOLD = "bold";
    public static final String PROPERTY_FILL = "fill";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FORECOLOR = "forecolor";
    public static final String PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String PROPERTY_ITALIC = "italic";
    public static final String PROPERTY_LINE_SPACING = "lineSpacing";
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_PDF_EMBEDDED = "pdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_RADIUS = "radius";
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_SCALE_IMAGE = "scaleImage";
    public static final String PROPERTY_STRIKE_THROUGH = "strikeThrough";
    public static final String PROPERTY_IS_STYLED_TEXT = "isStyledText";
    public static final String PROPERTY_MARKUP = "markup";
    public static final String PROPERTY_UNDERLINE = "underline";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    protected JRDefaultStyleProvider defaultStyleProvider = null;
    protected JRStyle parentStyle = null;
    protected String parentStyleNameReference;
    protected String name = null;
    protected boolean isDefault = false;
    protected Byte positionType = null;
    protected Byte stretchType = null;
    protected Byte mode = null;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRPen linePen = null;
    protected Byte fill = null;
    protected Integer radius = null;
    protected Byte scaleImage = null;
    protected Byte horizontalAlignment = null;
    protected Byte verticalAlignment = null;
    protected JRLineBox lineBox = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    protected Byte rotation = null;
    protected Byte lineSpacing = null;
    protected String markup = null;
    protected String pattern = null;
    protected Boolean isBlankWhenNull = null;
    protected JRConditionalStyle[] conditionalStyles;
    private transient JRPropertyChangeSupport eventSupport;
    private Byte pen;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private Boolean isStyledText = null;

    public JRBaseStyle() {
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
    }

    public JRBaseStyle(String name) {
        this.name = name;
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
    }

    public JRBaseStyle(JRStyle style, JRAbstractObjectFactory factory) {
        this.name = style.getName();
        factory.setStyle(new JRStyleSetter(){

            @Override
            public void setStyle(JRStyle aStyle) {
                JRBaseStyle.this.setParentStyle(aStyle);
            }

            @Override
            public void setStyleNameReference(String name) {
                JRBaseStyle.this.parentStyleNameReference = name;
            }
        }, style);
        this.isDefault = style.isDefault();
        this.mode = style.getOwnMode();
        this.forecolor = style.getOwnForecolor();
        this.backcolor = style.getOwnBackcolor();
        this.linePen = style.getLinePen().clone(this);
        this.fill = style.getOwnFill();
        this.radius = style.getOwnRadius();
        this.scaleImage = style.getOwnScaleImage();
        this.horizontalAlignment = style.getOwnHorizontalAlignment();
        this.verticalAlignment = style.getOwnVerticalAlignment();
        this.lineBox = style.getLineBox().clone(this);
        this.rotation = style.getOwnRotation();
        this.lineSpacing = style.getOwnLineSpacing();
        this.markup = style.getOwnMarkup();
        this.pattern = style.getOwnPattern();
        this.fontName = style.getOwnFontName();
        this.isBold = style.isOwnBold();
        this.isItalic = style.isOwnItalic();
        this.isUnderline = style.isOwnUnderline();
        this.isStrikeThrough = style.isOwnStrikeThrough();
        this.fontSize = style.getOwnFontSize();
        this.pdfFontName = style.getOwnPdfFontName();
        this.pdfEncoding = style.getOwnPdfEncoding();
        this.isPdfEmbedded = style.isOwnPdfEmbedded();
        this.isBlankWhenNull = style.isOwnBlankWhenNull();
        JRConditionalStyle[] condStyles = style.getConditionalStyles();
        if (condStyles != null && condStyles.length > 0) {
            this.conditionalStyles = new JRConditionalStyle[condStyles.length];
            for (int i = 0; i < condStyles.length; ++i) {
                this.conditionalStyles[i] = factory.getConditionalStyle(condStyles[i], this);
            }
        }
    }

    protected void setParentStyle(JRStyle parentStyle) {
        this.parentStyle = parentStyle;
        this.checkCircularParent();
    }

    protected void checkCircularParent() {
        for (JRStyle ancestor = this.parentStyle; ancestor != null; ancestor = ancestor.getStyle()) {
            if (ancestor != this) continue;
            throw new JRRuntimeException("Circular dependency detected for style " + this.getName());
        }
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public Byte getPen() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.linePen));
    }

    @Override
    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    @Override
    public void setPen(byte pen) {
        this.setPen(new Byte(pen));
    }

    @Override
    public void setPen(Byte pen) {
        JRPenUtil.setLinePenFromPen(pen, this.linePen);
    }

    @Override
    public Byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    @Override
    public Byte getOwnFill() {
        return this.fill;
    }

    @Override
    public Integer getRadius() {
        return JRStyleResolver.getRadius(this);
    }

    @Override
    public Integer getOwnRadius() {
        return this.radius;
    }

    @Override
    public Byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    @Override
    public Byte getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public Byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public Byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public Byte getBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getPen()));
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    @Override
    public Integer getPadding() {
        return this.lineBox.getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    @Override
    public Byte getTopBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen()));
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    @Override
    public Integer getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    @Override
    public Byte getLeftBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen()));
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    @Override
    public Integer getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    @Override
    public Byte getBottomBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen()));
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    @Override
    public Integer getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    @Override
    public Byte getRightBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen()));
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    @Override
    public Integer getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    @Override
    public Byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    @Override
    public Byte getOwnRotation() {
        return this.rotation;
    }

    @Override
    public Byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    @Override
    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    @Override
    public Boolean isStyledText() {
        String mkp = this.getMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    @Override
    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public Boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public Boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public Boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public Boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public Boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public Integer getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public Boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public Byte getMode() {
        return JRStyleResolver.getMode(this);
    }

    @Override
    public Byte getOwnMode() {
        return this.mode;
    }

    @Override
    public void setForecolor(Color forecolor) {
        Color old = this.forecolor;
        this.forecolor = forecolor;
        this.getEventSupport().firePropertyChange(PROPERTY_FORECOLOR, old, this.forecolor);
    }

    @Override
    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    @Override
    public void setMode(byte mode) {
        this.setMode(new Byte(mode));
    }

    @Override
    public void setMode(Byte mode) {
        Byte old = this.mode;
        this.mode = mode;
        this.getEventSupport().firePropertyChange(PROPERTY_MODE, old, this.mode);
    }

    @Override
    public void setFill(byte fill) {
        this.setFill(new Byte(fill));
    }

    @Override
    public void setFill(Byte fill) {
        Byte old = this.fill;
        this.fill = fill;
        this.getEventSupport().firePropertyChange(PROPERTY_FILL, old, this.fill);
    }

    @Override
    public void setRadius(int radius) {
        this.setRadius(new Integer(radius));
    }

    @Override
    public void setRadius(Integer radius) {
        Integer old = this.radius;
        this.radius = radius;
        this.getEventSupport().firePropertyChange(PROPERTY_RADIUS, old, this.radius);
    }

    @Override
    public void setScaleImage(byte scaleImage) {
        this.setScaleImage(new Byte(scaleImage));
    }

    @Override
    public void setScaleImage(Byte scaleImage) {
        Byte old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange(PROPERTY_SCALE_IMAGE, old, this.scaleImage);
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(new Byte(horizontalAlignment));
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
        Byte old = this.horizontalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_ALIGNMENT, old, this.horizontalAlignment);
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
        this.setVerticalAlignment(new Byte(verticalAlignment));
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
        Byte old = this.verticalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_ALIGNMENT, old, this.verticalAlignment);
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    @Override
    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRotation(byte rotation) {
        this.setRotation(new Byte(rotation));
    }

    @Override
    public void setRotation(Byte rotation) {
        Byte old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, old, this.rotation);
    }

    @Override
    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, old, this.fontName);
    }

    @Override
    public void setBold(boolean bold) {
        this.setBold(bold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean bold) {
        Boolean old = this.isBold;
        this.isBold = bold;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, old, this.isBold);
    }

    @Override
    public void setItalic(boolean italic) {
        this.setItalic(italic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean italic) {
        Boolean old = this.isItalic;
        this.isItalic = italic;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, old, this.isItalic);
    }

    @Override
    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.setPdfEmbedded(pdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean pdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = pdfEmbedded;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, old, this.isPdfEmbedded);
    }

    @Override
    public void setStrikeThrough(boolean strikeThrough) {
        this.setStrikeThrough(strikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean strikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = strikeThrough;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, old, this.isStrikeThrough);
    }

    @Override
    public void setStyledText(boolean styledText) {
        this.setStyledText(styledText ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStyledText(Boolean styledText) {
        if (styledText == null) {
            this.setMarkup(null);
        } else {
            this.setMarkup(styledText != false ? "styled" : "none");
        }
    }

    @Override
    public void setMarkup(String markup) {
        String old = this.markup;
        this.markup = markup;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKUP, old, this.markup);
    }

    @Override
    public void setBlankWhenNull(boolean isBlankWhenNull) {
        this.setBlankWhenNull(isBlankWhenNull ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBlankWhenNull(Boolean isBlankWhenNull) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlankWhenNull;
        this.getEventSupport().firePropertyChange(PROPERTY_BLANK_WHEN_NULL, old, this.isBlankWhenNull);
    }

    @Override
    public void setUnderline(boolean underline) {
        this.setUnderline(underline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean underline) {
        Boolean old = this.isUnderline;
        this.isUnderline = underline;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, old, this.isUnderline);
    }

    @Override
    public void setLineSpacing(byte lineSpacing) {
        this.setLineSpacing(new Byte(lineSpacing));
    }

    @Override
    public void setLineSpacing(Byte lineSpacing) {
        Byte old = this.lineSpacing;
        this.lineSpacing = lineSpacing;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_SPACING, old, this.lineSpacing);
    }

    @Override
    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN, old, this.pattern);
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, old, this.pdfEncoding);
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, old, this.pdfFontName);
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        Integer old = this.fontSize;
        this.fontSize = fontSize;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, old, this.fontSize);
    }

    @Override
    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStyles;
    }

    @Override
    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    @Override
    public Float getDefaultLineWidth() {
        return null;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseStyle jRBaseStyle = this;
        synchronized (jRBaseStyle) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
    }

    @Override
    public Object clone() {
        try {
            JRBaseStyle clone = (JRBaseStyle)super.clone();
            clone.lineBox = this.lineBox == null ? null : this.lineBox.clone(clone);
            JRPen jRPen = clone.linePen = this.linePen == null ? null : this.linePen.clone(clone);
            if (this.conditionalStyles != null) {
                clone.conditionalStyles = new JRConditionalStyle[this.conditionalStyles.length];
                for (int i = 0; i < this.conditionalStyles.length; ++i) {
                    JRConditionalStyle styleClone;
                    JRConditionalStyle style = this.conditionalStyles[i];
                    clone.conditionalStyles[i] = styleClone = (JRConditionalStyle)style.clone();
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }
}

