/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;

public class CrosstabConverter
extends FrameConverter {
    private static final CrosstabConverter INSTANCE = new CrosstabConverter();

    private CrosstabConverter() {
    }

    public static ElementConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        JRCrosstab crosstab = (JRCrosstab)element;
        this.copyElement(reportConverter, crosstab, printFrame);
        List children = this.getCrosstabChildren(reportConverter, crosstab);
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                printFrame.addElement((JRPrintElement)children.get(i));
            }
        }
        return printFrame;
    }

    private List getCrosstabChildren(ReportConverter reportConverter, JRCrosstab crosstab) {
        ArrayList<JRPrintFrame> crosstabElements = new ArrayList<JRPrintFrame>();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i = 0; i < rowGroups.length; ++i) {
            rowHeadersXOffset += rowGroups[i].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i = 0; i < columnGroups.length; ++i) {
            colHeadersYOffset += columnGroups[i].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null && headerCell.getWidth() != 0 && headerCell.getHeight() != 0) {
            crosstabElements.add(this.getCrosstabCellFrame(reportConverter, headerCell, 0, 0, false, false, false));
        }
        this.addCrosstabColumnHeaders(reportConverter, crosstab, rowHeadersXOffset, crosstabElements);
        this.addCrosstabRows(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset, crosstabElements);
        if (crosstab.getRunDirection() == 1) {
            this.mirrorElements(crosstabElements, crosstab.getX(), crosstab.getWidth());
        }
        return crosstabElements;
    }

    private void mirrorElements(List elements, int x, int width) {
        for (JRElement element : elements) {
            int mirrorX = 2 * x + width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    private JRPrintFrame getCrosstabCellFrame(ReportConverter reportConverter, JRCellContents cell, int x, int y, boolean left, boolean right, boolean top) {
        List children;
        JRBasePrintFrame frame = new JRBasePrintFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(reportConverter.resolveStyle(cell));
        JRLineBox box = cell.getLineBox();
        if (box != null) {
            boolean copyTop;
            frame.copyBox(box);
            boolean copyLeft = left && box.getLeftPen().getLineWidth().floatValue() <= 0.0f && box.getRightPen().getLineWidth().floatValue() > 0.0f;
            boolean copyRight = right && box.getRightPen().getLineWidth().floatValue() <= 0.0f && box.getLeftPen().getLineWidth().floatValue() > 0.0f;
            boolean bl = copyTop = top && box.getTopPen().getLineWidth().floatValue() <= 0.0f && box.getBottomPen().getLineWidth().floatValue() > 0.0f;
            if (copyLeft) {
                ((JRBaseLineBox)frame.getLineBox()).copyLeftPen(box.getRightPen());
            }
            if (copyRight) {
                ((JRBaseLineBox)frame.getLineBox()).copyRightPen(box.getLeftPen());
            }
            if (copyTop) {
                ((JRBaseLineBox)frame.getLineBox()).copyTopPen(box.getBottomPen());
            }
        }
        if ((children = cell.getChildren()) != null && children.size() > 0) {
            ConvertVisitor convertVisitor = new ConvertVisitor(reportConverter, frame);
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).visit(convertVisitor);
            }
        }
        return frame;
    }

    private void addCrosstabColumnHeaders(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, List crosstabElements) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCellContents totalHeader;
            JRCellContents header;
            boolean firstOnRow;
            JRCellContents totalHeader2;
            JRCrosstabColumnGroup group = groups[i];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
                x += totalHeader2.getWidth();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, rowHeadersXOffset + x + header.getWidth(), y, false, false, false));
            }
            y += group.getHeight();
        }
    }

    private void addCrosstabRows(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, int colHeadersYOffset, List crosstabElements) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCellContents totalHeader;
            JRCellContents header;
            JRCellContents totalHeader2;
            JRCrosstabRowGroup group = groups[i];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, i, crosstabElements);
                y += totalHeader2.getHeight();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
            }
            if (i == groups.length - 1) {
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, groups.length, crosstabElements);
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, x, colHeadersYOffset + y + header.getHeight(), false, false, false));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y + header.getHeight(), i, crosstabElements);
            }
            x += group.getWidth();
        }
    }

    private void addCrosstabDataCellsRow(ReportConverter reportConverter, JRCrosstab crosstab, int rowOffsetX, int rowOffsetY, int rowIndex, List crosstabElements) {
        JRCrosstabCell[][] cells = crosstab.getCells();
        if (cells != null) {
            JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
            int crosstabX = rowOffsetX;
            int crosstabY = rowOffsetY;
            int x = 0;
            for (int i = 0; i < colGroups.length; ++i) {
                JRCellContents contents;
                JRCrosstabCell cell;
                JRCrosstabColumnGroup group = colGroups[i];
                if (group.getTotalPosition() == 1 && (cell = cells[rowIndex][i]) != null && (contents = cell.getContents()).getWidth() != 0 && contents.getHeight() != 0) {
                    crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x, crosstabY, false, false, false));
                    x += cells[rowIndex][i].getContents().getWidth();
                }
                if (i == colGroups.length - 1 && (cell = cells[rowIndex][colGroups.length]) != null && (contents = cell.getContents()).getWidth() != 0 && contents.getHeight() != 0) {
                    crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x, crosstabY, false, false, false));
                }
                if (group.getTotalPosition() != 2 || (cell = cells[rowIndex][i]) == null || (contents = cell.getContents()).getWidth() == 0 || contents.getHeight() == 0) continue;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x + group.getHeader().getWidth(), crosstabY, false, false, false));
            }
        }
    }
}

