/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementIconConverter
extends ElementConverter {
    private static final Log log = LogFactory.getLog(ElementIconConverter.class);
    private final String iconLocation;

    public ElementIconConverter(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        this.copyElement(reportConverter, element, printImage);
        printImage.getLineBox().setPadding(3);
        printImage.setScaleImage((byte)1);
        printImage.setRenderer(this.getRenderer());
        return printImage;
    }

    protected JRRenderable getRenderer() {
        try {
            return JRImageRenderer.getInstance(this.iconLocation, (byte)1);
        }
        catch (JRException e) {
            log.warn((Object)"Error creating component design preview icon", (Throwable)e);
            return null;
        }
    }
}

