/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRMapCollectionDataSource
implements JRRewindableDataSource {
    private Collection records = null;
    private Iterator iterator = null;
    private Map currentRecord = null;

    public JRMapCollectionDataSource(Collection col) {
        this.records = col;
        if (this.records != null) {
            this.iterator = this.records.iterator();
        }
    }

    @Override
    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = (Map)this.iterator.next();
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField field) {
        Object value = null;
        if (this.currentRecord != null) {
            value = this.currentRecord.get(field.getName());
        }
        return value;
    }

    @Override
    public void moveFirst() {
        if (this.records != null) {
            this.iterator = this.records.iterator();
        }
    }

    public Collection getData() {
        return this.records;
    }

    public int getRecordCount() {
        return this.records == null ? 0 : this.records.size();
    }

    public JRMapCollectionDataSource cloneDataSource() {
        return new JRMapCollectionDataSource(this.records);
    }
}

