/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_CHART_TYPE = "chartType";
    public static final String PROPERTY_CUSTOMIZER_CLASS = "customizerClass";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_LEGEND_FONT = "legendFont";
    public static final String PROPERTY_SUBTITLE_EXPRESSION = "subtitleExpression";
    public static final String PROPERTY_SUBTITLE_FONT = "subtitleFont";
    public static final String PROPERTY_TITLE_EXPRESSION = "titleExpression";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    protected byte chartType = 0;
    protected Boolean showLegend = null;
    protected byte evaluationTime = 1;
    protected String linkType;
    protected String linkTarget;
    protected Color titleColor = null;
    protected Color subtitleColor = null;
    protected Color legendColor = null;
    protected Color legendBackgroundColor = null;
    protected String renderType;
    protected String theme;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected Byte legendPositionByte = null;
    protected Byte titlePositionByte = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    private List hyperlinkParameters;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected JRLineBox lineBox;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 30103;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private boolean isShowLegend = false;
    private byte titlePosition = 1;
    private byte legendPosition = (byte)2;
    private byte hyperlinkType = 0;
    private byte hyperlinkTarget = 1;

    public JRDesignChart(JRDefaultStyleProvider defaultStyleProvider, byte chartType) {
        super(defaultStyleProvider);
        this.setChartType(chartType);
        this.titleFont = new JRBaseFont(this, null);
        this.subtitleFont = new JRBaseFont(this, null);
        this.legendFont = new JRBaseFont(this, null);
        this.hyperlinkParameters = new ArrayList();
        this.lineBox = new JRBaseLineBox(this);
    }

    @Override
    public boolean isShowLegend() {
        return this.showLegend == null ? false : this.showLegend;
    }

    @Override
    public void setShowLegend(boolean isShowLegend) {
        this.setShowLegend((Boolean)isShowLegend);
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange("showLegend", old, this.showLegend);
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange("renderType", old, this.renderType);
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange("theme", old, this.theme);
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte evaluationTime) {
        byte old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup group) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = group;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    @Override
    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox box) {
        JRBoxUtil.setBoxToLineBox(box, this.lineBox);
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont font) {
        JRFont old = this.titleFont;
        this.titleFont = new JRBaseFont(this, font);
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_FONT, old, this.titleFont);
    }

    @Override
    public byte getTitlePosition() {
        return this.titlePositionByte == null ? (byte)1 : this.titlePositionByte;
    }

    @Override
    public void setTitlePosition(byte titlePosition) {
        this.setTitlePosition(new Byte(titlePosition));
    }

    @Override
    public Byte getTitlePositionByte() {
        return this.titlePositionByte;
    }

    @Override
    public void setTitlePosition(Byte titlePosition) {
        Byte old = this.titlePositionByte;
        this.titlePositionByte = titlePosition;
        this.getEventSupport().firePropertyChange("titlePosition", old, this.titlePositionByte);
    }

    @Override
    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange("titleColor", old, this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont font) {
        JRFont old = this.subtitleFont;
        this.subtitleFont = new JRBaseFont(this, font);
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_FONT, old, this.subtitleFont);
    }

    @Override
    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    @Override
    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange("subtitleColor", old, this.subtitleColor);
    }

    @Override
    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    @Override
    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    @Override
    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange("legendColor", old, this.legendColor);
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange("legendBackgroundColor", old, this.legendBackgroundColor);
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont legendFont) {
        JRFont old = this.legendFont;
        this.legendFont = new JRBaseFont(this, legendFont);
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_FONT, old, this.legendFont);
    }

    @Override
    public byte getLegendPosition() {
        return this.legendPositionByte == null ? (byte)2 : this.legendPositionByte;
    }

    @Override
    public void setLegendPosition(byte legendPosition) {
        this.setLegendPosition(new Byte(legendPosition));
    }

    @Override
    public Byte getLegendPositionByte() {
        return this.legendPositionByte;
    }

    @Override
    public void setLegendPosition(Byte legendPosition) {
        Byte old = this.legendPositionByte;
        this.legendPositionByte = legendPosition;
        this.getEventSupport().firePropertyChange("legendPosition", old, this.legendPositionByte);
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression expression) {
        JRExpression old = this.titleExpression;
        this.titleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_EXPRESSION, old, this.titleExpression);
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression expression) {
        JRExpression old = this.subtitleExpression;
        this.subtitleExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_EXPRESSION, old, this.subtitleExpression);
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte chartType) {
        byte old = this.chartType;
        this.chartType = chartType;
        switch (chartType) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot, this);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot, this);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot, this);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 17: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot, this);
                break;
            }
            case 19: {
                this.plot = new JRDesignMultiAxisPlot(this.plot, this);
                this.dataset = null;
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot, this);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot, this);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot, this);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 18: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot, this);
                break;
            }
            case 16: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot, this);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 20: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 21: {
                this.dataset = new JRDesignGanttDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_TYPE, old, this.chartType);
    }

    public void setDataset(JRChartDataset ds) {
        JRChartDataset old = this.dataset;
        switch (ds.getDatasetType()) {
            case 2: {
                this.dataset = (JRDesignCategoryDataset)ds;
                break;
            }
            case 7: {
                this.dataset = (JRDesignHighLowDataset)ds;
                break;
            }
            case 1: {
                this.dataset = (JRDesignPieDataset)ds;
                break;
            }
            case 5: {
                this.dataset = (JRDesignTimePeriodDataset)ds;
                break;
            }
            case 6: {
                this.dataset = (JRDesignTimeSeriesDataset)ds;
                break;
            }
            case 8: {
                this.dataset = (JRDesignValueDataset)ds;
                break;
            }
            case 3: {
                this.dataset = (JRDesignXyDataset)ds;
                break;
            }
            case 4: {
                this.dataset = (JRDesignXyzDataset)ds;
                break;
            }
            case 9: {
                this.dataset = (JRDesignGanttDataset)ds;
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        String old = this.customizerClass;
        this.customizerClass = customizerClass;
        this.getEventSupport().firePropertyChange(PROPERTY_CUSTOMIZER_CLASS, old, this.customizerClass);
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.lineBox.getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("linkType", old, this.linkType);
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = (JRHyperlinkParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    protected void normalizeLinkTarget() {
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(this.hyperlinkTarget);
        }
        this.hyperlinkTarget = 1;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRDesignChart clone = (JRDesignChart)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new ArrayList(this.hyperlinkParameters.size());
            for (int i = 0; i < this.hyperlinkParameters.size(); ++i) {
                clone.hyperlinkParameters.add(((JRHyperlinkParameter)this.hyperlinkParameters.get(i)).clone());
            }
        }
        if (this.titleExpression != null) {
            clone.titleExpression = (JRExpression)this.titleExpression.clone();
        }
        if (this.subtitleExpression != null) {
            clone.subtitleExpression = (JRExpression)this.subtitleExpression.clone();
        }
        if (this.anchorNameExpression != null) {
            clone.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        if (this.dataset != null) {
            clone.dataset = (JRChartDataset)this.dataset.clone();
        }
        if (this.plot != null) {
            clone.plot = (JRChartPlot)this.plot.clone(clone);
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
        this.normalizeLinkTarget();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
            this.showLegend = this.isShowLegend;
            this.legendPositionByte = new Byte(this.legendPosition);
            this.titlePositionByte = new Byte(this.titlePosition);
        }
    }
}

