/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRDesignImage
extends JRDesignGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    protected Byte scaleImage;
    protected Byte horizontalAlignment;
    protected Byte verticalAlignment;
    protected Boolean isUsingCache = null;
    protected boolean isLazy = false;
    protected byte onErrorType = 1;
    protected byte evaluationTime = 1;
    protected String linkType;
    protected String linkTarget;
    private List hyperlinkParameters = new ArrayList();
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private byte hyperlinkType = 0;
    private byte hyperlinkTarget = 1;

    public JRDesignImage(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    @Override
    public Byte getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public void setScaleImage(byte scaleImage) {
        this.setScaleImage(new Byte(scaleImage));
    }

    @Override
    public void setScaleImage(Byte scaleImage) {
        Byte old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImage);
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(new Byte(horizontalAlignment));
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
        Byte old = this.horizontalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignment);
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
        this.setVerticalAlignment(new Byte(verticalAlignment));
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
        Byte old = this.verticalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignment);
    }

    @Override
    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            if (this.getExpression() != null) {
                return String.class.getName().equals(this.getExpression().getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    @Override
    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox box) {
        JRBoxUtil.setBoxToLineBox(box, this.lineBox);
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("usingCache", old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange("lazy", old, this.isLazy);
    }

    @Override
    public byte getOnErrorType() {
        return this.onErrorType;
    }

    @Override
    public void setOnErrorType(byte onErrorType) {
        byte old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange("onErrorType", old, this.onErrorType);
    }

    public void setEvaluationTime(byte evaluationTime) {
        byte old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public void setEvaluationGroup(JRGroup evaluationGroup) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.lineBox.getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("linkType", old, this.linkType);
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = (JRHyperlinkParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    protected void normalizeLinkTarget() {
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(this.hyperlinkTarget);
        }
        this.hyperlinkTarget = 1;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Object clone() {
        JRDesignImage clone = (JRDesignImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new ArrayList(this.hyperlinkParameters.size());
            for (int i = 0; i < this.hyperlinkParameters.size(); ++i) {
                clone.hyperlinkParameters.add(((JRHyperlinkParameter)this.hyperlinkParameters.get(i)).clone());
            }
        }
        if (this.expression != null) {
            clone.expression = (JRExpression)this.expression.clone();
        }
        if (this.anchorNameExpression != null) {
            clone.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
        this.normalizeLinkTarget();
    }
}

