/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class ImageDrawer
extends ElementDrawer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) throws JRException {
        JRPrintImage printImage = (JRPrintImage)element;
        if (printImage.getMode() == 1) {
            grx.setColor(printImage.getBackcolor());
            grx.fillRect(printImage.getX() + offsetX, printImage.getY() + offsetY, printImage.getWidth(), printImage.getHeight());
        }
        int topPadding = printImage.getLineBox().getTopPadding();
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0 && (renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, printImage.getOnErrorType())) != null) {
                renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, printImage.getOnErrorType());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    Shape oldClipShape = grx.getClip();
                    grx.clip(new Rectangle(printImage.getX() + leftPadding + offsetX, printImage.getY() + topPadding + offsetY, availableImageWidth, availableImageHeight));
                    try {
                        renderer.render(grx, new Rectangle(printImage.getX() + leftPadding + offsetX + xoffset, printImage.getY() + topPadding + offsetY + yoffset, normalWidth, normalHeight));
                        break;
                    }
                    finally {
                        grx.setClip(oldClipShape);
                    }
                }
                case 2: {
                    renderer.render(grx, new Rectangle(printImage.getX() + leftPadding + offsetX, printImage.getY() + topPadding + offsetY, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(grx, new Rectangle(printImage.getX() + leftPadding + offsetX + xoffset, printImage.getY() + topPadding + offsetY + yoffset, normalWidth, normalHeight));
                }
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() != 0.0f) {
                this.drawPen(grx, printImage.getLinePen(), printImage, offsetX, offsetY);
            }
        } else {
            this.drawBox(grx, printImage.getLineBox(), printImage, offsetX, offsetY);
        }
    }
}

