/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.xmlss.JRXmlssExporterNature;
import net.sf.jasperreports.engine.export.xmlss.XmlssContentBuilder;
import net.sf.jasperreports.engine.export.xmlss.XmlssStyleCache;
import net.sf.jasperreports.engine.export.xmlss.XmlssTableBuilder;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRXmlssExporter
extends JRAbstractExporter {
    public static final String XMLSS_EXPORTER_KEY = "net.sf.jasperreports.xmlss";
    private static final String XMLSS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xmlss.";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    protected static final String VERTICAL_ALIGN_TOP = "top";
    protected static final String VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected static final String[] PAGE_LAYOUT = new String[]{"Portrait", "Portrait", "Landscape"};
    protected Writer tempBodyWriter = null;
    protected Writer tempStyleWriter = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected int tableIndex = 0;
    protected boolean startPage;
    protected String encoding = null;
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    private XmlssStyleCache styleCache = null;
    protected ExporterNature nature = null;
    protected File destFile = null;
    protected boolean isOnePagePerSheet;
    protected boolean isRemoveEmptySpaceBetweenRows;
    protected boolean isRemoveEmptySpaceBetweenColumns;
    protected boolean isWhitePageBackground;
    protected boolean isAutoDetectCellType = false;
    protected boolean isDetectCellType;
    protected boolean isFontSizeFixEnabled;
    protected boolean isIgnoreGraphics;
    protected boolean isCollapseRowSpan;
    protected boolean isIgnoreCellBorder;
    protected boolean isIgnorePageMargins;
    protected int maxRowsPerSheet;
    protected String[] sheetNames = null;
    protected int sheetIndex = 0;
    protected Map sheetNamesMap = null;
    protected String currentSheetName = null;
    protected JRFont defaultFont = null;
    protected Map formatPatternsMap = null;
    protected byte pageOrientation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block15: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XMLSS_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                this.nature = new JRXmlssExporterNature(this.filter, this.isIgnorePageMargins);
                this.pageOrientation = this.jasperPrint.getOrientation();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block15;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.exportReportToStream(outWriter);
                        break block15;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(os, this.encoding));
                        break block15;
                    }
                    catch (Exception e) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void exportReportToFile() throws JRException {
        Writer writer = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
            this.exportReportToStream(writer);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + this.destFile, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        try {
            this.exportReportToStream(buffer);
        }
        catch (IOException e) {
            throw new JRException("Error while exporting report to buffer", e);
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        this.tempBodyWriter = new StringWriter();
        this.tempStyleWriter = new StringWriter();
        this.styleCache = new XmlssStyleCache(this.tempStyleWriter, this.fontMap);
        this.sheetNamesMap = new HashMap();
        this.sheetNamesMap.put("Page", new Integer(0));
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                            this.tempBodyWriter.write("<Worksheet ss:Name=\"" + this.getSheetName(this.sheetNames[this.sheetIndex]) + "\">\n");
                        } else {
                            this.tempBodyWriter.write("<Worksheet ss:Name=\"" + this.getSheetName("Page") + "\">\n");
                        }
                        ++this.sheetIndex;
                        this.tempBodyWriter.write("<Table>\n");
                        this.exportPage(page, null, 0, null, true);
                        this.tempBodyWriter.write("</Table>\n");
                        this.closeWorksheet();
                    }
                } else {
                    if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                        this.tempBodyWriter.write("<Worksheet ss:Name=\"" + this.getSheetName(this.sheetNames[this.sheetIndex]) + "\">\n");
                    } else {
                        this.tempBodyWriter.write("<Worksheet ss:Name=\"" + this.getSheetName(this.jasperPrint.getName()) + "\">\n");
                    }
                    this.tempBodyWriter.write("<Table>\n");
                    ++this.sheetIndex;
                    CutsInfo xCuts = JRGridLayout.calculateXCuts(this.nature, pages, this.startPageIndex, this.endPageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int startRow = 0;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow, null, pageIndex == this.startPageIndex);
                    }
                    if (this.isRemoveEmptySpaceBetweenColumns) {
                        // empty if block
                    }
                    this.tempBodyWriter.write("</Table>\n");
                    this.closeWorksheet();
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        XmlssContentBuilder xmlssContentBuilder = new XmlssContentBuilder(writer, this.tempStyleWriter, this.tempBodyWriter);
        xmlssContentBuilder.build();
    }

    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow, JRPrintElementIndex frameIndex, boolean isNewSheet) throws JRException {
        try {
            XmlssTableBuilder tableBuilder;
            boolean createXCuts;
            JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, xCuts);
            JRExporterGridCell[][] grid = layout.getGrid();
            boolean bl = createXCuts = xCuts == null;
            if (createXCuts) {
                xCuts = layout.getXCuts();
            }
            CutsInfo yCuts = layout.getYCuts();
            int skippedRows = 0;
            int rowIndex = startRow;
            XmlssTableBuilder xmlssTableBuilder = tableBuilder = frameIndex == null ? new XmlssTableBuilder(this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter) : new XmlssTableBuilder(frameIndex.toString(), this.tempBodyWriter, this.tempStyleWriter);
            if (isNewSheet) {
                this.buildColumns(xCuts, tableBuilder);
            }
            for (int y = 0; y < grid.length; ++y) {
                rowIndex = y - skippedRows + startRow;
                if (this.maxRowsPerSheet > 0 && rowIndex >= this.maxRowsPerSheet) {
                    tableBuilder.buildTableFooter();
                    this.closeWorksheet();
                    this.tempBodyWriter.write("<Worksheet ss:Name=\"" + this.getSheetName(this.currentSheetName) + "\">\n");
                    tableBuilder.buildTableHeader();
                    this.buildColumns(xCuts, tableBuilder);
                    startRow = 0;
                    rowIndex = 0;
                    skippedRows = y;
                }
                if (yCuts.isCutNotEmpty(y) || (!this.isRemoveEmptySpaceBetweenRows || yCuts.isCutSpanned(y)) && !this.isCollapseRowSpan) {
                    JRExporterGridCell[] gridRow = grid[y];
                    int emptyCellColSpan = 0;
                    int emptyCellRowSpan = 0;
                    int emptyCellWidth = 0;
                    int rowHeight = this.isCollapseRowSpan ? JRGridLayout.getMaxRowHeight(gridRow) : JRGridLayout.getRowHeight(gridRow);
                    tableBuilder.buildRowHeader(rowIndex, rowHeight);
                    int emptyCols = 0;
                    for (int colIndex = 0; colIndex < gridRow.length; ++colIndex) {
                        emptyCols += this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(colIndex) && !xCuts.isCutSpanned(colIndex) ? 1 : 0;
                        JRExporterGridCell gridCell = gridRow[colIndex];
                        if (gridCell.getWrapper() != null) {
                            JRPrintElement element;
                            if (emptyCellColSpan > 0) {
                                tableBuilder.buildEmptyCell(emptyCellColSpan, emptyCellRowSpan);
                                emptyCellColSpan = 0;
                                emptyCellWidth = 0;
                            }
                            if (!((element = gridCell.getWrapper().getElement()) instanceof JRPrintLine || element instanceof JRPrintRectangle || element instanceof JRPrintEllipse || element instanceof JRPrintImage)) {
                                if (element instanceof JRPrintText) {
                                    this.exportText(tableBuilder, (JRPrintText)element, gridCell);
                                } else if (element instanceof JRPrintFrame) {
                                    // empty if block
                                }
                            }
                            colIndex += gridCell.getColSpan() - 1;
                            continue;
                        }
                        ++emptyCellColSpan;
                        emptyCellWidth += gridCell.getWidth();
                    }
                    if (emptyCellColSpan > 0) {
                        tableBuilder.buildEmptyCell(emptyCellColSpan, emptyCellRowSpan);
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    tableBuilder.buildRowFooter();
                    ++rowIndex;
                    continue;
                }
                ++skippedRows;
            }
            if (!createXCuts || this.isRemoveEmptySpaceBetweenColumns) {
                // empty if block
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.afterPageExport();
            }
            return rowIndex;
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void exportText(XmlssTableBuilder tableBuilder, JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        String pattern = this.getConvertedPattern(this.getTextValue(text, styledText.getText()));
        int colspan = gridCell.getColSpan();
        int rowspan = gridCell.getRowSpan();
        String formula = text.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(text, gridCell.getBackcolor(), pattern, this.isFontSizeFixEnabled, this.defaultFont, this.fontMap), colspan, rowspan, this.getHyperlinkURL(text), text.getHyperlinkTooltip(), formula);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.tempBodyWriter.write(" <ss:Data ss:Type=\"" + this.getType(this.getTextValue(text, styledText.getText())) + "\" xmlns=\"http://www.w3.org/TR/REC-html40\">");
        if (textLength > 0) {
            this.exportStyledText(styledText);
        }
        this.tempBodyWriter.write(" </ss:Data>\n");
        tableBuilder.buildCellFooter();
    }

    protected void exportStyledText(JRStyledText styledText) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text) throws IOException {
        boolean hasFont = false;
        boolean isBold = false;
        boolean isItalic = false;
        boolean isStrikethrough = false;
        boolean isUnderline = false;
        boolean isSubscript = false;
        boolean isSuperscript = false;
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            isBold = true;
            this.tempBodyWriter.write("<B>");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            isItalic = true;
            this.tempBodyWriter.write("<I>");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            isUnderline = true;
            this.tempBodyWriter.write("<U>");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            isStrikethrough = true;
            this.tempBodyWriter.write("<S>");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            isSuperscript = true;
            this.tempBodyWriter.write("<Sup>");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            isSubscript = true;
            this.tempBodyWriter.write("<Sub>");
        }
        Font font = (Font)attributes.get(TextAttribute.FONT);
        if (font != null) {
            int size;
            String fontFace = font.getFontName();
            if (fontFace != null) {
                if (!hasFont) {
                    hasFont = true;
                    this.startFontTag();
                }
                this.tempBodyWriter.write(" html:Face=\"" + fontFace + "\"");
            }
            if ((size = font.getSize()) > 0) {
                if (!hasFont) {
                    hasFont = true;
                    this.startFontTag();
                }
                this.tempBodyWriter.write(" html:Size=\"" + size + "\"");
            }
        } else {
            Number size;
            String fontFamily;
            String fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
            String string = fontFamily = this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr) ? (String)this.fontMap.get(fontFamilyAttr) : fontFamilyAttr;
            if (fontFamily != null) {
                if (!hasFont) {
                    hasFont = true;
                    this.startFontTag();
                }
                this.tempBodyWriter.write(" html:Face=\"" + fontFamily + "\"");
            }
            if ((size = (Number)attributes.get(TextAttribute.SIZE)) != null) {
                if (!hasFont) {
                    hasFont = true;
                    this.startFontTag();
                }
                this.tempBodyWriter.write(" html:Size=\"" + size + "\"");
            }
        }
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (forecolor != null && !forecolor.equals(Color.BLACK)) {
            if (!hasFont) {
                hasFont = true;
                this.startFontTag();
            }
            this.tempBodyWriter.write(" html:Color=\"#" + JRColorUtil.getColorHexa(forecolor) + "\"");
        }
        if (hasFont) {
            this.tempBodyWriter.write(">");
        }
        if (text != null) {
            this.tempBodyWriter.write(JRStringUtil.xmlEncode(text).replaceAll("\n", "&#10;"));
        }
        if (hasFont) {
            this.tempBodyWriter.write("</Font>");
        }
        if (isSubscript) {
            this.tempBodyWriter.write("</Sub>");
        }
        if (isSuperscript) {
            this.tempBodyWriter.write("</Sup>");
        }
        if (isStrikethrough) {
            this.tempBodyWriter.write("</S>");
        }
        if (isUnderline) {
            this.tempBodyWriter.write("</U>");
        }
        if (isItalic) {
            this.tempBodyWriter.write("</I>");
        }
        if (isBold) {
            this.tempBodyWriter.write("</B>");
        }
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(XmlssTableBuilder tableBuilder, JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        boolean appendBackcolor;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(frame, gridCell.getBackcolor(), null, this.isFontSizeFixEnabled, this.defaultFont, this.fontMap), gridCell.getColSpan(), gridCell.getRowSpan(), null, null, null);
        boolean bl = appendBackcolor = frame.getMode() == 1 && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = gridCell.getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableBuilder.buildCellFooter();
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    protected void writeHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (link != null) {
            this.tempBodyWriter.write(" ss:Href=\"");
            this.tempBodyWriter.write(href);
            this.tempBodyWriter.write("\"");
            if (link.getHyperlinkTooltip() != null) {
                this.tempBodyWriter.write(" x:HRefScreenTip=\"");
                this.tempBodyWriter.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.tempBodyWriter.write("\"");
            }
            this.tempBodyWriter.write(">");
        }
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpaceBetweenRows = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isRemoveEmptySpaceBetweenColumns = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, "net.sf.jasperreports.export.xls.remove.empty.space.between.columns", false);
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        Boolean isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsAbstractExporterParameter.IS_AUTO_DETECT_CELL_TYPE);
        if (isAutoDetectCellTypeParameter != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        this.isDetectCellType = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.isCollapseRowSpan = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.sheetNames = (String[])this.parameters.get(JRXlsAbstractExporterParameter.SHEET_NAMES);
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
        this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
        this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
        this.setHyperlinkProducerFactory();
    }

    protected void startFontTag() throws IOException {
        this.tempBodyWriter.write("<Font");
    }

    protected void endFontTag() throws IOException {
        this.tempBodyWriter.write("</Font>");
    }

    private String getSheetName(String sheetName) {
        this.currentSheetName = sheetName;
        if (!this.sheetNamesMap.containsKey(sheetName)) {
            this.sheetNamesMap.put(sheetName, new Integer(1));
            return sheetName;
        }
        int currentIndex = (Integer)this.sheetNamesMap.get(sheetName) + 1;
        this.sheetNamesMap.put(sheetName, new Integer(currentIndex));
        return sheetName + " " + currentIndex;
    }

    protected void buildColumns(CutsInfo xCuts, XmlssTableBuilder tableBuilder) {
        for (int col = 0; col < xCuts.size() - 1; ++col) {
            if (this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(col) && !xCuts.isCutSpanned(col)) continue;
            int width = xCuts.getCut(col + 1) - xCuts.getCut(col);
            try {
                tableBuilder.buildColumnTag(col + 1, width);
                continue;
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    String getType(TextValue textValue) {
        String type = "String";
        if (textValue instanceof NumberTextValue) {
            type = "Number";
        } else if (textValue instanceof DateTextValue) {
            type = "DateTime";
        } else if (textValue instanceof BooleanTextValue) {
            type = "Boolean";
        }
        return type;
    }

    String getConvertedPattern(TextValue textValue) {
        String pattern = "General";
        if (textValue instanceof NumberTextValue && ((NumberTextValue)textValue).getPattern() != null) {
            pattern = ((NumberTextValue)textValue).getPattern();
        } else if (textValue instanceof DateTextValue && ((DateTextValue)textValue).getPattern() != null) {
            pattern = ((DateTextValue)textValue).getPattern();
        }
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
            return (String)this.formatPatternsMap.get(pattern);
        }
        return pattern;
    }

    private void closeWorksheet() throws IOException {
        this.tempBodyWriter.write("<x:WorksheetOptions>\n");
        this.tempBodyWriter.write(" <x:PageSetup>\n");
        this.tempBodyWriter.write("  <x:Layout x:Orientation=\"" + PAGE_LAYOUT[this.pageOrientation] + "\"/>\n");
        this.tempBodyWriter.write(" </x:PageSetup>\n");
        this.tempBodyWriter.write("</x:WorksheetOptions>\n");
        this.tempBodyWriter.write("</Worksheet>\n");
    }

    @Override
    protected String getExporterKey() {
        return XMLSS_EXPORTER_KEY;
    }
}

