/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.xmlss.XmlssStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public abstract class XmlssBorderStyle
extends XmlssStyle {
    private static final String[] border = new String[]{"Top", "Left", "Bottom", "Right"};
    protected static final int TOP_BORDER = 0;
    protected static final int LEFT_BORDER = 1;
    protected static final int BOTTOM_BORDER = 2;
    protected static final int RIGHT_BORDER = 3;
    protected JRPrintElement element = null;
    private String[] borderColor = new String[4];
    private String[] borderWidth = new String[4];
    private String[] borderStyle = new String[4];
    private String[] borderPadding = new String[4];

    public XmlssBorderStyle(Writer styleWriter, JRPrintElement element) {
        super(styleWriter);
        this.element = element;
    }

    public void setBox(JRLineBox box) throws IOException {
        this.appendBorder(box.getTopPen(), 0);
        this.appendBorder(box.getLeftPen(), 1);
        this.appendBorder(box.getBottomPen(), 2);
        this.appendBorder(box.getRightPen(), 3);
    }

    public void setPen(JRPen pen) throws IOException {
        if (this.borderWidth[0] == null && this.borderWidth[1] == null && this.borderWidth[2] == null && this.borderWidth[3] == null) {
            this.appendBorder(pen, 0);
            this.appendBorder(pen, 1);
            this.appendBorder(pen, 2);
            this.appendBorder(pen, 3);
        }
    }

    @Override
    public String getId() {
        return this.borderWidth[0] + "|" + this.borderColor[0] + "|" + this.borderStyle[0] + "|" + this.borderPadding[0] + "|" + this.borderWidth[1] + "|" + this.borderColor[1] + "|" + this.borderStyle[1] + "|" + this.borderPadding[1] + "|" + this.borderWidth[2] + "|" + this.borderColor[2] + "|" + this.borderStyle[2] + "|" + this.borderPadding[2] + "|" + this.borderWidth[3] + "|" + this.borderColor[3] + "|" + this.borderStyle[3] + "|" + this.borderPadding[3];
    }

    protected void writeBorder(int side) throws IOException {
        if (this.borderWidth[side] != null) {
            this.styleWriter.write("  <ss:Border ");
            this.styleWriter.write("ss:Position=\"" + border[side] + "\" ");
            this.styleWriter.write("ss:LineStyle=\"" + this.borderStyle[side] + "\" ");
            this.styleWriter.write("ss:Weight=\"" + this.borderWidth[side] + "\" ");
            this.styleWriter.write("ss:Color=\"#" + this.borderColor[side] + "\"/>");
        }
    }

    private void appendBorder(JRPen pen, int side) throws IOException {
        float width = pen.getLineWidth().floatValue();
        String style = null;
        if (width > 0.0f) {
            switch (pen.getLineStyle()) {
                case 2: {
                    style = "Dot";
                    break;
                }
                case 1: {
                    style = "Dash";
                    break;
                }
                default: {
                    style = "Continuous";
                }
            }
            this.borderWidth[side] = 0.0f < width && 0.6f > width ? "1" : (0.6f <= width && 1.5f > width ? "2" : "3");
        } else {
            style = "None";
        }
        this.borderStyle[side] = style;
        this.borderColor[side] = JRColorUtil.getColorHexa(pen.getLineColor());
    }
}

