/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    protected final JRLineBox lineBox;
    private JRFillFrameElements frameContainer;
    private Map bottomTemplateFrames;
    private Map topTemplateFrames;
    private Map topBottomTemplateFrames;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller filler, JRFrame frame, JRFillObjectFactory factory) {
        super(filler, frame, factory);
        this.parentFrame = frame;
        this.lineBox = frame.getLineBox().clone(this);
        this.frameContainer = new JRFillFrameElements(factory);
        this.bottomTemplateFrames = new HashMap();
        this.topTemplateFrames = new HashMap();
        this.topBottomTemplateFrames = new HashMap();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame frame, JRFillCloneFactory factory) {
        super(frame, factory);
        this.parentFrame = frame.parentFrame;
        this.lineBox = frame.getLineBox().clone(this);
        this.frameContainer = new JRFillFrameElements(frame.frameContainer, factory);
        this.bottomTemplateFrames = frame.bottomTemplateFrames;
        this.topTemplateFrames = frame.topTemplateFrames;
        this.topBottomTemplateFrames = frame.topBottomTemplateFrames;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.evaluateProperties(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(evaluation);
            boolean repeating = true;
            JRFillElement[] elements = (JRFillElement[])this.getElements();
            for (int i = 0; repeating && i < elements.length; repeating &= elements[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(repeating);
        }
        this.filling = false;
    }

    @Override
    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !isOverflow || !this.filling;
        int topPadding = this.first ? this.getLineBox().getTopPadding() : 0;
        int bottomPadding = this.getLineBox().getBottomPadding();
        if (availableHeight < this.getRelativeY() + this.getHeight() - topPadding) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && isOverflow && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        this.frameContainer.prepareElements(availableHeight - this.getRelativeY() + bottomPadding + this.getLineBox().getTopPadding() - topPadding, true);
        boolean willOverflow = this.frameContainer.willOverflow();
        if (willOverflow) {
            this.fillBottomBorder = false;
            this.setStretchHeight(availableHeight - this.getRelativeY());
        } else {
            int neededStretch = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding;
            if (neededStretch <= availableHeight - this.getRelativeY()) {
                this.fillBottomBorder = true;
                this.setStretchHeight(neededStretch);
            } else {
                this.fillBottomBorder = false;
                this.setStretchHeight(availableHeight - this.getRelativeY());
            }
        }
        this.filling = willOverflow;
        return willOverflow;
    }

    @Override
    protected void setStretchHeight(int stretchHeight) {
        super.setStretchHeight(stretchHeight);
        int topPadding = this.first ? this.getLineBox().getTopPadding() : 0;
        int bottomPadding = this.fillBottomBorder ? this.getLineBox().getBottomPadding() : 0;
        this.frameContainer.setStretchHeight(stretchHeight + this.frameContainer.getFirstY() - topPadding - bottomPadding);
    }

    @Override
    protected void stretchHeightFinal() {
        if (this.isToPrint()) {
            this.frameContainer.stretchElements();
            this.frameContainer.moveBandBottomElements();
            this.frameContainer.removeBlankElements();
            int topPadding = this.first ? this.getLineBox().getTopPadding() : 0;
            int bottomPadding = this.fillBottomBorder ? this.getLineBox().getBottomPadding() : 0;
            super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding);
        }
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplate());
        printFrame.setX(this.getX());
        printFrame.setY(this.getRelativeY());
        printFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(printFrame);
        printFrame.setHeight(this.getStretchHeight());
        this.transferProperties(printFrame);
        return printFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle style = this.getStyle();
        Map templatesMap = this.first ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame boxTemplate = (JRTemplateFrame)templatesMap.get(style);
        if (boxTemplate == null) {
            boxTemplate = this.createFrameTemplate();
            this.transferProperties(boxTemplate);
            if (this.first) {
                if (!this.fillBottomBorder) {
                    boxTemplate.copyBox(this.getLineBox());
                    JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, false, true);
                }
            } else if (this.fillBottomBorder) {
                boxTemplate.copyBox(this.getLineBox());
                JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, true, false);
            } else {
                boxTemplate.copyBox(this.getLineBox());
                JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, true, true);
            }
            templatesMap.put(style, boxTemplate);
        }
        return boxTemplate;
    }

    protected JRTemplateFrame createFrameTemplate() {
        return new JRTemplateFrame(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return this.createFrameTemplate();
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    @Override
    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.getLineBox().getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.getLineBox().setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.getLineBox().setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.getLineBox().getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.getLineBox().getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getLineBox().getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.getLineBox().getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
    }

    @Override
    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillFrame(this, factory);
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory factory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, factory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements frameElements, JRFillCloneFactory factory) {
            super(frameElements, factory);
            this.initElements();
        }

        @Override
        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getLineBox().getTopPadding() - JRFillFrame.this.getLineBox().getBottomPadding();
        }
    }
}

