/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup = null;
    private JRRenderable renderer = null;
    private boolean hasOverflowed;
    private Integer imageHeight;
    private Integer imageWidth;
    private Integer imageX;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected final JRLineBox lineBox;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super(image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = image.evaluationGroup;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    @Override
    public Byte getOwnScaleImage() {
        return ((JRImage)this.parent).getOwnScaleImage();
    }

    @Override
    public void setScaleImage(byte scaleImage) {
    }

    @Override
    public void setScaleImage(Byte scaleImage) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRImage)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRImage)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    @Override
    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    @Override
    public void setLazy(boolean isLazy) {
    }

    @Override
    public byte getOnErrorType() {
        return ((JRImage)this.parent).getOnErrorType();
    }

    @Override
    public void setOnErrorType(byte onErrorType) {
    }

    @Override
    public byte getEvaluationTime() {
        return ((JRImage)this.parent).getEvaluationTime();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public byte getBorder() {
        return this.getBox().getBorder();
    }

    @Override
    public Byte getOwnBorder() {
        return this.getBox().getOwnBorder();
    }

    @Override
    public void setBorder(byte border) {
        this.getBox().setBorder(border);
    }

    @Override
    public void setBorder(Byte border) {
        this.getBox().setBorder(border);
    }

    @Override
    public Color getBorderColor() {
        return this.getBox().getBorderColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.getBox().getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.getBox().setBorderColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.getBox().getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.getBox().getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.getBox().setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.getBox().setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return this.getBox().getTopBorder();
    }

    @Override
    public Byte getOwnTopBorder() {
        return this.getBox().getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte topBorder) {
        this.getBox().setTopBorder(topBorder);
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        this.getBox().setTopBorder(topBorder);
    }

    @Override
    public Color getTopBorderColor() {
        return this.getBox().getTopBorderColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.getBox().getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.getBox().setTopBorderColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.getBox().getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.getBox().getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.getBox().setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.getBox().setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return this.getBox().getLeftBorder();
    }

    @Override
    public Byte getOwnLeftBorder() {
        return this.getBox().getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        this.getBox().setLeftBorder(leftBorder);
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        this.getBox().setLeftBorder(leftBorder);
    }

    @Override
    public Color getLeftBorderColor() {
        return this.getBox().getLeftBorderColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.getBox().getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.getBox().setLeftBorderColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.getBox().getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.getBox().getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.getBox().setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.getBox().setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return this.getBox().getBottomBorder();
    }

    @Override
    public Byte getOwnBottomBorder() {
        return this.getBox().getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        this.getBox().setBottomBorder(bottomBorder);
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        this.getBox().setBottomBorder(bottomBorder);
    }

    @Override
    public Color getBottomBorderColor() {
        return this.getBox().getBottomBorderColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.getBox().getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getBox().setBottomBorderColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.getBox().getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.getBox().getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.getBox().setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.getBox().setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return this.getBox().getRightBorder();
    }

    @Override
    public Byte getOwnRightBorder() {
        return this.getBox().getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        this.getBox().setRightBorder(rightBorder);
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        this.getBox().setRightBorder(rightBorder);
    }

    @Override
    public Color getRightBorderColor() {
        return this.getBox().getRightBorderColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.getBox().getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.getBox().setRightBorderColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.getBox().getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.getBox().getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.getBox().setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.getBox().setRightPadding(rightPadding);
    }

    @Override
    public byte getHyperlinkType() {
        return ((JRImage)this.parent).getHyperlinkType();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    @Override
    public String getLinkTarget() {
        return ((JRImage)this.parent).getLinkTarget();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        JRTemplateImage template = new JRTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        if (this.getScaleImage() == 4 || this.getScaleImage() == 5) {
            template.setScaleImage((byte)3);
        }
        return template;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.hasOverflowed = false;
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        JRExpression expression = this.getExpression();
        JRRenderable newRenderer = null;
        Object source = this.evaluateExpression(expression, evaluation);
        if (source != null) {
            if (this.isUsingCache() && this.filler.fillContext.hasLoadedImage(source)) {
                newRenderer = this.filler.fillContext.getLoadedImage(source).getRenderer();
            } else {
                Object img;
                Class expressionClass = expression.getValueClass();
                if (Image.class.getName().equals(expressionClass.getName())) {
                    img = (Image)source;
                    newRenderer = JRImageRenderer.getInstance((Image)img, this.getOnErrorType());
                } else if (InputStream.class.getName().equals(expressionClass.getName())) {
                    InputStream is = (InputStream)source;
                    newRenderer = JRImageRenderer.getInstance(is, this.getOnErrorType());
                } else if (URL.class.getName().equals(expressionClass.getName())) {
                    URL url = (URL)source;
                    newRenderer = JRImageRenderer.getInstance(url, this.getOnErrorType());
                } else if (File.class.getName().equals(expressionClass.getName())) {
                    File file = (File)source;
                    newRenderer = JRImageRenderer.getInstance(file, this.getOnErrorType());
                } else if (String.class.getName().equals(expressionClass.getName())) {
                    String location = (String)source;
                    newRenderer = JRImageRenderer.getInstance(location, this.getOnErrorType(), this.isLazy(), this.filler.reportClassLoader, this.filler.urlHandlerFactory, this.filler.fileResolver);
                } else if (JRRenderable.class.getName().equals(expressionClass.getName())) {
                    newRenderer = (JRRenderable)source;
                }
                if (this.isUsingCache()) {
                    img = new JRTemplatePrintImage(this.getJRTemplateImage());
                    img.setRenderer(newRenderer);
                    this.filler.fillContext.registerLoadedImage(source, (JRPrintImage)img);
                }
            }
        }
        this.setValueRepeating(this.renderer == newRenderer);
        this.renderer = newRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight < this.getRelativeY() + this.getHeight()) {
                    isToPrint = false;
                    willOverflow = true;
                } else if (!(this.isLazy() || this.getScaleImage() != 4 && this.getScaleImage() != 5)) {
                    int padding = this.getLineBox().getBottomPadding() + this.getLineBox().getTopPadding();
                    boolean reprinted = isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues());
                    boolean imageOverflowAllowed = this.filler.isBandOverFlowAllowed() && !reprinted && !this.hasOverflowed;
                    boolean fits = this.fitImage(availableHeight - this.getRelativeY() - padding, imageOverflowAllowed, this.getHorizontalAlignment());
                    if (fits) {
                        if (this.imageHeight != null) {
                            this.setStretchHeight(this.imageHeight + padding);
                        }
                    } else {
                        this.hasOverflowed = true;
                        isToPrint = false;
                        willOverflow = true;
                        this.setStretchHeight(availableHeight - this.getRelativeY() - padding);
                    }
                }
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected void reset() {
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        super.reset();
    }

    protected boolean fitImage(int availableHeight, boolean overflowAllowed, byte hAlign) throws JRException {
        boolean fitted;
        Dimension2D imageSize;
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        Dimension2D dimension2D = imageSize = this.renderer == null ? null : this.renderer.getDimension();
        if (imageSize == null) {
            return true;
        }
        int realHeight = (int)imageSize.getHeight();
        int realWidth = (int)imageSize.getWidth();
        int reducedHeight = realHeight;
        int reducedWidth = realWidth;
        if (realWidth > this.getWidth()) {
            double wRatio = (double)this.getWidth() / (double)realWidth;
            reducedHeight = (int)(wRatio * (double)realHeight);
            reducedWidth = this.getWidth();
        }
        if (reducedHeight <= availableHeight) {
            this.imageHeight = new Integer(reducedHeight);
            if (this.getScaleImage() == 5) {
                this.imageWidth = new Integer(reducedWidth);
            }
            fitted = true;
        } else if (overflowAllowed) {
            fitted = false;
        } else {
            this.imageHeight = new Integer(availableHeight);
            if (this.getScaleImage() == 5) {
                double hRatio = (double)availableHeight / (double)realHeight;
                this.imageWidth = new Integer((int)(hRatio * (double)realWidth));
            }
            fitted = true;
        }
        if (this.imageWidth != null && this.imageWidth.intValue() != this.getWidth()) {
            switch (hAlign) {
                case 3: {
                    this.imageX = new Integer(this.getX() + this.getWidth() - this.imageWidth);
                    break;
                }
                case 2: {
                    this.imageX = new Integer(this.getX() + (this.getWidth() - this.imageWidth) / 2);
                    break;
                }
            }
        }
        return fitted;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        byte evaluationType = this.getEvaluationTime();
        if (this.isEvaluateAuto()) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage());
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
            recordedValuesImage = null;
        }
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        if (this.isEvaluateNow()) {
            this.copy(printImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationType, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        if (this.imageX != null) {
            printImage.setX(this.imageX);
        }
        if (this.imageWidth != null) {
            printImage.setWidth(this.imageWidth);
        }
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(printImage);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        JRPrintImage printImage = (JRPrintImage)element;
        int padding = printImage.getLineBox().getBottomPadding() + printImage.getLineBox().getTopPadding();
        this.fitImage(this.getHeight() - padding, false, printImage.getHorizontalAlignment());
        this.copy(printImage);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    @Override
    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

