/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final JRSingletonCache markupProcessorFactoryCache = new JRSingletonCache(MarkupProcessorFactory.class);
    private static final Map markupProcessors = new HashMap();
    private boolean isLeftToRight = true;
    private JRTextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private short[] lineBreakOffsets;
    private String textTruncateSuffix;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributesMap = new HashMap();
    protected final JRReportFont reportFont;
    protected final JRLineBox lineBox;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.lineBox = textElement.getLineBox().clone(this);
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.reportFont = textElement.reportFont;
        this.lineBox = textElement.getLineBox().clone(this);
    }

    private void createTextMeasurer() {
        this.textMeasurer = JRTextMeasurerUtil.createTextMeasurer(this);
    }

    protected void ensureTextMeasurer() {
        if (this.textMeasurer == null) {
            this.createTextMeasurer();
        }
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getTextAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public void setTextAlignment(byte horizontalAlignment) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    @Override
    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    @Override
    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    @Override
    public void setRotation(byte rotation) {
    }

    @Override
    public void setRotation(Byte rotation) {
    }

    @Override
    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    @Override
    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(byte lineSpacing) {
    }

    @Override
    public void setLineSpacing(Byte lineSpacing) {
    }

    @Override
    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    @Override
    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    @Override
    public void setStyledText(boolean isStyledText) {
    }

    @Override
    public void setStyledText(Boolean isStyledText) {
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return ((JRTextElement)this.parent).getOwnMarkup();
    }

    public void setMarkup(String markup) {
    }

    @Override
    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.getLineBox().getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.getLineBox().setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.getLineBox().setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.getLineBox().getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.getLineBox().getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getLineBox().getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.getLineBox().getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    @Override
    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        HashMap<TextAttribute, Color> styledTextAttributes = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<TextAttribute, Color>();
            JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    protected void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    protected void resetTextChunk() {
        this.textStart = 0;
        this.textEnd = 0;
        this.lineBreakOffsets = null;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    @Override
    protected void rewind() {
        this.resetTextChunk();
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            this.styledText = this.filler.getStyledTextParser().getStyledText(this.getStyledTextAttributes(), text, !"none".equals(this.getMarkup()), this.filler.getLocale());
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        this.ensureTextMeasurer();
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        if (this.getTextEnd() == tmpStyledText.getText().length()) {
            return;
        }
        JRMeasuredText measuredText = this.textMeasurer.measure(tmpStyledText, this.getTextEnd(), availableStretchHeight, this.canOverflow());
        this.isLeftToRight = measuredText.isLeftToRight();
        this.setTextHeight(measuredText.getTextHeight());
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight() + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(measuredText.getTextOffset());
        this.setLineBreakOffsets(measuredText.getLineBreakOffsets());
        this.setTextTruncateSuffix(measuredText.getTextSuffix());
        this.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        this.setLeadingOffset(measuredText.getLeadingOffset());
    }

    protected abstract boolean canOverflow();

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont reportFont) {
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    @Override
    public void setFontName(String fontName) {
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    @Override
    public void setBold(boolean isBold) {
    }

    @Override
    public void setBold(Boolean isBold) {
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    @Override
    public void setItalic(boolean isItalic) {
    }

    @Override
    public void setItalic(Boolean isItalic) {
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    @Override
    public void setUnderline(boolean isUnderline) {
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    @Override
    public void setFontSize(int size) {
    }

    @Override
    public void setFontSize(Integer size) {
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int size) {
    }

    @Override
    public void setSize(Integer size) {
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    protected String processMarkupText(String text) {
        String markup;
        if ((text = JRStringUtil.replaceCRwithLF(text)) != null && !"none".equals(markup = this.getMarkup()) && !"styled".equals(markup)) {
            text = JRFillTextElement.getMarkupProcessor(markup).convert(text);
        }
        return text;
    }

    protected static MarkupProcessor getMarkupProcessor(String markup) {
        MarkupProcessor markupProcessor = (MarkupProcessor)markupProcessors.get(markup);
        if (markupProcessor == null) {
            String factoryClass = JRProperties.getProperty("net.sf.jasperreports.markup.processor.factory." + markup);
            if (factoryClass == null) {
                throw new JRRuntimeException("No markup processor factory specifyed for '" + markup + "' markup.");
            }
            MarkupProcessorFactory factory = null;
            try {
                factory = (MarkupProcessorFactory)markupProcessorFactoryCache.getCachedInstance(factoryClass);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            markupProcessor = factory.createMarkupProcessor();
            markupProcessors.put(markup, markupProcessor);
        }
        return markupProcessor;
    }

    protected void setPrintText(JRPrintText printText) {
        boolean keepAllText;
        int startIndex = this.getTextStart();
        int endIndex = this.getTextEnd();
        JRStyledText fullStyledText = this.getStyledText();
        String fullText = fullStyledText.getText();
        boolean bl = keepAllText = !this.canOverflow() && JRProperties.getBooleanProperty(this, "net.sf.jasperreports.print.keep.full.text", false);
        if (keepAllText) {
            if (startIndex != 0) {
                throw new JRRuntimeException("Text start index != 0 on keep all text.");
            }
            if (!"none".equals(this.getMarkup())) {
                String styledText = this.filler.getStyledTextParser().write(fullStyledText);
                printText.setText(styledText);
            } else {
                printText.setText(fullText);
            }
            if (endIndex < fullText.length()) {
                printText.setTextTruncateIndex(new Integer(endIndex));
            }
        } else {
            String printedText = !"none".equals(this.getMarkup()) ? this.filler.getStyledTextParser().write(fullStyledText, startIndex, endIndex) : fullText.substring(startIndex, endIndex);
            printText.setText(printedText);
        }
        printText.setTextTruncateSuffix(this.getTextTruncateSuffix());
        printText.setLineBreakOffsets(this.getLineBreakOffsets());
    }

    protected String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    protected void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }
}

