/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRTemplateGraphicElement
extends JRTemplateElement
implements JRCommonGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen = null;
    private Byte fill = null;
    private Byte pen;

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
    }

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRGraphicElement graphicElement) {
        super(origin, defaultStyleProvider);
        this.setGraphicElement(graphicElement);
    }

    protected void setGraphicElement(JRGraphicElement graphicElement) {
        super.setElement(graphicElement);
        this.copyLinePen(graphicElement.getLinePen());
        this.setFill(graphicElement.getOwnFill());
    }

    public void copyLinePen(JRPen pen) {
        this.linePen = pen.clone(this);
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    public byte getPen() {
        return JRPenUtil.getPenFromLinePen(this.linePen);
    }

    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    public void setPen(byte pen) {
        this.setPen(new Byte(pen));
    }

    public void setPen(Byte pen) {
        JRPenUtil.setLinePenFromPen(pen, this.linePen);
    }

    @Override
    public byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    @Override
    public Byte getOwnFill() {
        return this.fill;
    }

    public void setFill(byte fill) {
        this.fill = new Byte(fill);
    }

    public void setFill(Byte fill) {
        this.fill = fill;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

