/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRTemplateText
extends JRTemplateElement
implements JRAlignment,
JRBox,
JRFont,
JRCommonText {
    private static final long serialVersionUID = 10200L;
    private Byte horizontalAlignment = null;
    private Byte verticalAlignment = null;
    private Byte rotation = null;
    private Byte lineSpacing = null;
    private String markup = null;
    private String linkType;
    private String linkTarget;
    protected JRLineBox lineBox;
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    protected String valueClassName;
    protected String pattern;
    protected String formatFactoryClass;
    protected String localeCode;
    protected String timeZoneId;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private Boolean isStyledText = null;
    private byte hyperlinkType = 0;
    private byte hyperlinkTarget = 1;

    protected JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRStaticText staticText) {
        super(origin, defaultStyleProvider);
        this.setStaticText(staticText);
    }

    protected JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRTextField textField) {
        super(origin, defaultStyleProvider);
        this.setTextField(textField);
    }

    public JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
    }

    protected void setStaticText(JRStaticText staticText) {
        this.setTextElement(staticText);
    }

    protected void setTextField(JRTextField textField) {
        this.setTextElement(textField);
        this.setLinkType(textField.getLinkType());
        this.setLinkTarget(textField.getLinkTarget());
    }

    protected void setTextElement(JRTextElement textElement) {
        super.setElement(textElement);
        this.copyLineBox(textElement.getLineBox());
        this.reportFont = textElement.getReportFont();
        this.fontName = textElement.getOwnFontName();
        this.isBold = textElement.isOwnBold();
        this.isItalic = textElement.isOwnItalic();
        this.isUnderline = textElement.isOwnUnderline();
        this.isStrikeThrough = textElement.isOwnStrikeThrough();
        this.fontSize = textElement.getOwnFontSize();
        this.pdfFontName = textElement.getOwnPdfFontName();
        this.pdfEncoding = textElement.getOwnPdfEncoding();
        this.isPdfEmbedded = textElement.isOwnPdfEmbedded();
        this.horizontalAlignment = textElement.getOwnHorizontalAlignment();
        this.verticalAlignment = textElement.getOwnVerticalAlignment();
        this.rotation = textElement.getOwnRotation();
        this.lineSpacing = textElement.getOwnLineSpacing();
        this.markup = textElement.getOwnMarkup();
    }

    public void copyLineBox(JRLineBox box) {
        this.lineBox = box.clone(this);
    }

    protected JRFont getBaseFont() {
        if (this.reportFont != null) {
            return this.reportFont;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultFont();
        }
        return null;
    }

    @Override
    public int getWidth() {
        throw new JRRuntimeException("This method should never be called.");
    }

    @Override
    public int getHeight() {
        throw new JRRuntimeException("This method should never be called.");
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.horizontalAlignment = new Byte(horizontalAlignment);
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
        this.verticalAlignment = new Byte(verticalAlignment);
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    @Override
    public Byte getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(byte rotation) {
        this.setRotation(new Byte(rotation));
    }

    public void setRotation(Byte rotation) {
        this.rotation = rotation;
    }

    @Override
    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    @Override
    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(byte lineSpacing) {
        this.setLineSpacing(new Byte(lineSpacing));
    }

    public void setLineSpacing(Byte lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    @Override
    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public JRFont getFont() {
        return this;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this.getLinkType());
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this.getLinkTarget());
    }

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int size) {
        this.setFontSize(size);
    }

    @Override
    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    protected void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    protected void normalizeLinkTarget() {
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(this.hyperlinkTarget);
        }
        this.hyperlinkTarget = 1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    @Override
    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    @Override
    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    @Override
    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    @Override
    public int getPadding() {
        return this.lineBox.getPadding();
    }

    @Override
    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    @Override
    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    @Override
    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    @Override
    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    @Override
    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    @Override
    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    @Override
    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    @Override
    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    @Override
    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    @Override
    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    @Override
    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    @Override
    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    @Override
    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        this.normalizeLinkType();
        this.normalizeLinkTarget();
    }
}

