/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;
import net.sf.jasperreports.engine.util.JRQueryParser;

public abstract class JRAbstractQueryExecuter
implements JRQueryExecuter {
    protected static final int CLAUSE_POSITION_ID = 0;
    protected final Map clauseFunctions = new HashMap();
    protected final JRDataset dataset;
    private final Map parametersMap;
    private String queryString;
    private List queryParameters;
    private Set parameterClauseStack;

    protected JRAbstractQueryExecuter(JRDataset dataset, Map parametersMap) {
        this.dataset = dataset;
        this.parametersMap = parametersMap;
        this.queryString = "";
        this.queryParameters = new ArrayList();
    }

    protected void registerClauseFunction(String id, JRClauseFunction function) {
        this.clauseFunctions.put(id, function);
    }

    protected void unregisterClauseFunction(String id) {
        this.clauseFunctions.remove(id);
    }

    protected JRClauseFunction resolveFunction(String id) {
        JRClauseFunction function = (JRClauseFunction)this.clauseFunctions.get(id);
        if (function == null) {
            throw new JRRuntimeException("No clause function for id " + id + " found");
        }
        return function;
    }

    protected void parseQuery() {
        JRQueryChunk[] chunks;
        this.parameterClauseStack = new HashSet();
        JRQuery query = this.dataset.getQuery();
        if (query != null && (chunks = query.getChunks()) != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            for (int i = 0; i < chunks.length; ++i) {
                JRQueryChunk chunk = chunks[i];
                this.appendQueryChunk(sbuffer, chunk);
            }
            this.queryString = sbuffer.toString();
        }
    }

    protected void appendQueryChunk(StringBuffer sbuffer, JRQueryChunk chunk) {
        switch (chunk.getType()) {
            case 3: {
                this.appendParameterClauseChunk(sbuffer, chunk.getText());
                break;
            }
            case 2: {
                this.appendParameterChunk(sbuffer, chunk.getText());
                break;
            }
            case 4: {
                this.appendClauseChunk(sbuffer, chunk.getTokens());
                break;
            }
            default: {
                this.appendTextChunk(sbuffer, chunk.getText());
            }
        }
    }

    protected void appendTextChunk(StringBuffer sbuffer, String text) {
        sbuffer.append(text);
    }

    protected void appendParameterChunk(StringBuffer sbuffer, String chunkText) {
        String parameterName = chunkText;
        this.checkParameter(parameterName);
        sbuffer.append(this.getParameterReplacement(parameterName));
        this.addQueryParameter(chunkText);
    }

    protected void addQueryParameter(String parameterName) {
        QueryParameter param = new QueryParameter(parameterName);
        this.queryParameters.add(param);
    }

    protected void addQueryMultiParameters(String parameterName, int count) {
        QueryParameter param = new QueryParameter(parameterName, count);
        this.queryParameters.add(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendParameterClauseChunk(final StringBuffer sbuffer, String chunkText) {
        String parameterName = chunkText;
        this.checkParameter(parameterName);
        if (!this.parameterClauseStack.add(parameterName)) {
            throw new JRRuntimeException("The query contains circularly nested parameter clauses starting with " + parameterName);
        }
        try {
            Object parameterValue = this.getParameterValue(parameterName);
            String clauseText = String.valueOf(parameterValue);
            JRQueryChunkHandler nestedChunkHandler = new JRQueryChunkHandler(){

                @Override
                public void handleParameterChunk(String text) {
                    JRAbstractQueryExecuter.this.appendParameterChunk(sbuffer, text);
                }

                @Override
                public void handleParameterClauseChunk(String text) {
                    JRAbstractQueryExecuter.this.appendParameterClauseChunk(sbuffer, text);
                }

                @Override
                public void handleTextChunk(String text) {
                    JRAbstractQueryExecuter.this.appendTextChunk(sbuffer, text);
                }

                @Override
                public void handleClauseChunk(String[] tokens) {
                    JRAbstractQueryExecuter.this.appendClauseChunk(sbuffer, tokens);
                }
            };
            JRQueryParser.instance().parse(clauseText, nestedChunkHandler);
        }
        finally {
            this.parameterClauseStack.remove(parameterName);
        }
    }

    protected void appendClauseChunk(StringBuffer sbuffer, String[] clauseTokens) {
        JRClauseTokens tokens = new JRClauseTokens(clauseTokens);
        String id = tokens.getToken(0);
        if (id == null) {
            throw new JRRuntimeException("Query clause ID/first token missing");
        }
        JRClauseFunction function = this.resolveFunction(id);
        this.applyClause(function, tokens, sbuffer);
    }

    protected void applyClause(JRClauseFunction function, JRClauseTokens tokens, final StringBuffer sbuffer) {
        function.apply(tokens, new JRQueryClauseContext(){

            @Override
            public void addQueryMultiParameters(String parameterName, int count) {
                JRAbstractQueryExecuter.this.addQueryMultiParameters(parameterName, count);
            }

            @Override
            public void addQueryParameter(String parameterName) {
                JRAbstractQueryExecuter.this.addQueryParameter(parameterName);
            }

            @Override
            public JRValueParameter getValueParameter(String parameterName) {
                return JRAbstractQueryExecuter.this.getValueParameter(parameterName);
            }

            @Override
            public StringBuffer queryBuffer() {
                return sbuffer;
            }
        });
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected List getCollectedParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.queryParameters.size());
        for (QueryParameter param : this.queryParameters) {
            parameterNames.add(param.getName());
        }
        return parameterNames;
    }

    protected List getCollectedParameters() {
        return this.queryParameters;
    }

    protected Object getParameterValue(String parameterName, boolean ignoreMissing) {
        if (ignoreMissing) {
            JRValueParameter parameter = this.getValueParameter("REPORT_PARAMETERS_MAP", false);
            return ((Map)parameter.getValue()).get(parameterName);
        }
        JRValueParameter parameter = this.getValueParameter(parameterName, ignoreMissing);
        return parameter == null ? null : parameter.getValue();
    }

    protected Object getParameterValue(String parameterName) {
        return this.getParameterValue(parameterName, false);
    }

    protected JRFillParameter getParameter(String parameterName) {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter == null) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        return parameter;
    }

    protected void checkParameter(String parameterName) {
        if (!this.parametersMap.containsKey(parameterName)) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
    }

    protected JRValueParameter getValueParameter(String parameterName, boolean ignoreMissing) {
        JRValueParameter parameter = (JRValueParameter)this.parametersMap.get(parameterName);
        if (parameter == null && !ignoreMissing) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        return parameter;
    }

    protected JRValueParameter getValueParameter(String parameterName) {
        return this.getValueParameter(parameterName, false);
    }

    protected abstract String getParameterReplacement(String var1);

    protected static class QueryParameter {
        protected static final int COUNT_SINGLE = -1;
        private final String name;
        private final int count;

        public QueryParameter(String name) {
            this(name, -1);
        }

        public QueryParameter(String name, int count) {
            this.name = name;
            this.count = count;
        }

        public boolean isMulti() {
            return this.count != -1;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }
    }
}

