/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.query.JRSqlInClause;
import net.sf.jasperreports.engine.query.JRSqlNotInClause;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRJdbcQueryExecuter.class);
    protected static final String CLAUSE_ID_IN = "IN";
    protected static final String CLAUSE_ID_NOTIN = "NOTIN";
    protected static final String TYPE_FORWARD_ONLY = "forwardOnly";
    protected static final String TYPE_SCROLL_INSENSITIVE = "scrollInsensitive";
    protected static final String TYPE_SCROLL_SENSITIVE = "scrollSensitive";
    protected static final String CONCUR_READ_ONLY = "readOnly";
    protected static final String CONCUR_UPDATABLE = "updatable";
    protected static final String HOLD_CURSORS_OVER_COMMIT = "hold";
    protected static final String CLOSE_CURSORS_AT_COMMIT = "close";
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;

    public JRJdbcQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        this.registerFunctions();
        this.parseQuery();
    }

    protected void registerFunctions() {
        this.registerClauseFunction(CLAUSE_ID_IN, JRSqlInClause.instance());
        this.registerClauseFunction(CLAUSE_ID_NOTIN, JRSqlNotInClause.instance());
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return "?";
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource dataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                this.resultSet = this.statement.executeQuery();
                dataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException e) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), e);
            }
        }
        return dataSource;
    }

    protected void createStatement() throws JRException {
        String queryString = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL query string: " + queryString));
        }
        if (this.connection != null && queryString != null && queryString.trim().length() > 0) {
            try {
                List parameterNames;
                Integer reportMaxCount;
                int maxFieldSize;
                String type = JRProperties.getProperty(this.dataset, "net.sf.jasperreports.jdbc.result.set.type");
                String concurrency = JRProperties.getProperty(this.dataset, "net.sf.jasperreports.jdbc.concurrency");
                String holdability = JRProperties.getProperty(this.dataset, "net.sf.jasperreports.jdbc.holdability");
                if (type == null && concurrency == null && holdability == null) {
                    this.statement = this.connection.prepareStatement(queryString);
                } else {
                    type = type == null ? TYPE_FORWARD_ONLY : type;
                    concurrency = concurrency == null ? CONCUR_READ_ONLY : concurrency;
                    this.statement = holdability == null ? this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency)) : this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency), JRJdbcQueryExecuter.getHoldability(holdability, this.connection));
                }
                int fetchSize = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (fetchSize != 0) {
                    this.statement.setFetchSize(fetchSize);
                }
                if ((maxFieldSize = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.max.field.size", 0)) != 0) {
                    this.statement.setMaxFieldSize(maxFieldSize);
                }
                if ((reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT")) != null) {
                    this.statement.setMaxRows(reportMaxCount);
                }
                if (!(parameterNames = this.getCollectedParameters()).isEmpty()) {
                    int paramIdx = 1;
                    for (int i = 0; i < parameterNames.size(); ++i) {
                        JRAbstractQueryExecuter.QueryParameter queryParameter = (JRAbstractQueryExecuter.QueryParameter)parameterNames.get(i);
                        if (queryParameter.isMulti()) {
                            paramIdx += this.setStatementMultiParameters(paramIdx, queryParameter.getName());
                            continue;
                        }
                        this.setStatementParameter(paramIdx, queryParameter.getName());
                        ++paramIdx;
                    }
                }
            }
            catch (SQLException e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + queryString + "\n\n", e);
            }
        }
    }

    protected void setStatementParameter(int parameterIndex, String parameterName) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Class clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + " of type " + clazz.getName() + "): " + parameterValue));
        }
        this.setStatementParameter(parameterIndex, clazz, parameterValue);
    }

    protected int setStatementMultiParameters(int parameterIndex, String parameterName) throws SQLException {
        int count;
        Object paramValue = this.getParameterValue(parameterName);
        if (paramValue.getClass().isArray()) {
            int arrayCount = Array.getLength(paramValue);
            for (count = 0; count < arrayCount; ++count) {
                Object value = Array.get(paramValue, count);
                this.setStatementMultiParameter(parameterIndex + count, parameterName, count, value);
            }
        } else if (paramValue instanceof Collection) {
            Collection values = (Collection)paramValue;
            count = 0;
            for (Object value : values) {
                this.setStatementMultiParameter(parameterIndex + count, parameterName, count, value);
                ++count;
            }
        } else {
            throw new JRRuntimeException("Multi parameter value is not array nor collection.");
        }
        return count;
    }

    protected void setStatementMultiParameter(int parameterIndex, String parameterName, int valueIndex, Object value) throws SQLException {
        if (value == null) {
            throw new JRRuntimeException("Multi parameters cannot contain null values.");
        }
        Class<?> type = value.getClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + "[" + valueIndex + "] of type " + type.getName() + "): " + value));
        }
        this.setStatementParameter(parameterIndex, type, value);
    }

    protected void setStatementParameter(int parameterIndex, Class parameterType, Object parameterValue) throws SQLException {
        if (Boolean.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -7);
            } else {
                this.statement.setBoolean(parameterIndex, (Boolean)parameterValue);
            }
        } else if (Byte.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -6);
            } else {
                this.statement.setByte(parameterIndex, (Byte)parameterValue);
            }
        } else if (Double.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 8);
            } else {
                this.statement.setDouble(parameterIndex, (Double)parameterValue);
            }
        } else if (Float.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 6);
            } else {
                this.statement.setFloat(parameterIndex, ((Float)parameterValue).floatValue());
            }
        } else if (Integer.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 4);
            } else {
                this.statement.setInt(parameterIndex, (Integer)parameterValue);
            }
        } else if (Long.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -5);
            } else {
                this.statement.setLong(parameterIndex, (Long)parameterValue);
            }
        } else if (Short.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 5);
            } else {
                this.statement.setShort(parameterIndex, (Short)parameterValue);
            }
        } else if (BigDecimal.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 3);
            } else {
                this.statement.setBigDecimal(parameterIndex, (BigDecimal)parameterValue);
            }
        } else if (String.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 12);
            } else {
                this.statement.setString(parameterIndex, parameterValue.toString());
            }
        } else if (Timestamp.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 93);
            } else {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue);
            }
        } else if (Time.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 92);
            } else {
                this.statement.setTime(parameterIndex, (Time)parameterValue);
            }
        } else if (java.util.Date.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 91);
            } else {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()));
            }
        } else if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 2000);
        } else {
            this.statement.setObject(parameterIndex, parameterValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing result set.", (Throwable)e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing statement.", (Throwable)e);
            }
            finally {
                this.statement = null;
            }
        }
    }

    @Override
    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable t) {
                throw new JRException("Error cancelling SQL statement", t);
            }
        }
        return false;
    }

    protected static int getResultSetType(String type) {
        if (TYPE_FORWARD_ONLY.equals(type)) {
            return 1003;
        }
        if (TYPE_SCROLL_INSENSITIVE.equals(type)) {
            return 1004;
        }
        if (TYPE_SCROLL_SENSITIVE.equals(TYPE_SCROLL_SENSITIVE)) {
            return 1005;
        }
        return 1003;
    }

    protected static int getConcurrency(String concurrency) {
        if (CONCUR_READ_ONLY.equals(concurrency)) {
            return 1007;
        }
        if (CONCUR_UPDATABLE.equals(concurrency)) {
            return 1008;
        }
        return 1007;
    }

    protected static int getHoldability(String holdability, Connection connection) throws SQLException {
        if (HOLD_CURSORS_OVER_COMMIT.equals(holdability)) {
            return 1;
        }
        if (CLOSE_CURSORS_AT_COMMIT.equals(holdability)) {
            return 2;
        }
        return connection.getHoldability();
    }
}

