/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.util.Collection;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class JRSqlAbstractInClause
implements JRClauseFunction {
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;
    protected static final String CLAUSE_TRUISM = "0 = 0";

    protected JRSqlAbstractInClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException("SQL IN clause missing DB column token");
        }
        if (param == null) {
            throw new JRRuntimeException("SQL IN clause missing parameter token");
        }
        StringBuffer sbuffer = queryContext.queryBuffer();
        Object paramValue = queryContext.getValueParameter(param).getValue();
        if (paramValue == null) {
            this.handleNoValues(queryContext);
        } else {
            int count = this.valuesCount(param, paramValue);
            if (count == 0) {
                this.handleNoValues(queryContext);
            } else {
                sbuffer.append(col);
                sbuffer.append(' ');
                this.appendInOperator(sbuffer);
                sbuffer.append(' ');
                sbuffer.append('(');
                for (int idx = 0; idx < count; ++idx) {
                    if (idx > 0) {
                        sbuffer.append(", ");
                    }
                    sbuffer.append('?');
                }
                sbuffer.append(')');
                queryContext.addQueryMultiParameters(param, count);
            }
        }
    }

    protected void handleNoValues(JRQueryClauseContext queryContext) {
        queryContext.queryBuffer().append(CLAUSE_TRUISM);
    }

    protected int valuesCount(String paramName, Object paramValue) {
        int count;
        if (paramValue.getClass().isArray()) {
            count = Array.getLength(paramValue);
        } else if (paramValue instanceof Collection) {
            count = ((Collection)paramValue).size();
        } else {
            throw new JRRuntimeException("Invalid type " + paramValue.getClass().getName() + " for parameter " + paramName + " used in an IN clause; the value must be an array or a collection.");
        }
        return count;
    }

    protected abstract void appendInOperator(StringBuffer var1);
}

