/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.JRApiWriter;

public class ApiWriterVisitor
implements JRVisitor {
    private JRApiWriter apiWriter;
    private String name;

    public ApiWriterVisitor(JRApiWriter apiWriter) {
        this.apiWriter = apiWriter;
    }

    @Override
    public void visitBreak(JRBreak breakElement) {
        this.apiWriter.writeBreak(breakElement, this.name);
    }

    @Override
    public void visitChart(JRChart chart) {
        this.apiWriter.writeChartTag(chart, this.name);
    }

    @Override
    public void visitCrosstab(JRCrosstab crosstab) {
        this.apiWriter.writeCrosstab(crosstab, this.name);
    }

    @Override
    public void visitElementGroup(JRElementGroup elementGroup) {
        this.apiWriter.writeElementGroup(elementGroup, this.name);
    }

    @Override
    public void visitEllipse(JREllipse ellipse) {
        this.apiWriter.writeEllipse(ellipse, this.name);
    }

    @Override
    public void visitFrame(JRFrame frame) {
        this.apiWriter.writeFrame(frame, this.name);
    }

    @Override
    public void visitImage(JRImage image) {
        this.apiWriter.writeImage(image, this.name);
    }

    @Override
    public void visitLine(JRLine line) {
        this.apiWriter.writeLine(line, this.name);
    }

    @Override
    public void visitRectangle(JRRectangle rectangle) {
        this.apiWriter.writeRectangle(rectangle, this.name);
    }

    @Override
    public void visitStaticText(JRStaticText staticText) {
        this.apiWriter.writeStaticText(staticText, this.name);
    }

    @Override
    public void visitSubreport(JRSubreport subreport) {
        this.apiWriter.writeSubreport(subreport, this.name);
    }

    @Override
    public void visitTextField(JRTextField textField) {
        this.apiWriter.writeTextField(textField, this.name);
    }

    @Override
    public void visitComponentElement(JRComponentElement componentElement) {
        this.apiWriter.writeComponentElement(componentElement, this.name);
    }

    @Override
    public void visitGenericElement(JRGenericElement element) {
        this.apiWriter.writeGenericElement(element, this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

