/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.keypoint.PngEncoderB;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRAbstractImageEncoder;

public class JRDefaultImageEncoder
extends JRAbstractImageEncoder {
    @Override
    public byte[] encode(BufferedImage bi, byte imageType) throws JRException {
        byte[] bytes = null;
        switch (imageType) {
            case 3: {
                bytes = new PngEncoderB(bi).pngEncode();
                break;
            }
            case 2: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)baos);
                    JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
                    param.setQuality(1.0f, true);
                    encoder.encode(bi, param);
                }
                catch (IOException e) {
                    throw new JRException(e);
                }
                bytes = baos.toByteArray();
                break;
            }
            case 1: {
                throw new JRException("Image type GIF not supported by this image encoder.");
            }
            case 4: {
                throw new JRException("Image type TIFF not supported by this image encoder.");
            }
            default: {
                throw new JRException("Image type UNKNOWN not supported by this image encoder.");
            }
        }
        return bytes;
    }
}

