/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.JRDelegationVisitor;

public class JRElementsVisitor
extends JRDelegationVisitor {
    public static void visitReport(JRReport report, JRVisitor visitor) {
        JRElementsVisitor reportVisitor = new JRElementsVisitor(visitor);
        reportVisitor.visitReport(report);
    }

    public JRElementsVisitor(JRVisitor visitor) {
        super(visitor);
    }

    public void visitReport(JRReport report) {
        this.visitBand(report.getBackground());
        this.visitBand(report.getTitle());
        this.visitBand(report.getPageHeader());
        this.visitBand(report.getColumnHeader());
        this.visitSection(report.getDetailSection());
        this.visitBand(report.getColumnFooter());
        this.visitBand(report.getPageFooter());
        this.visitBand(report.getLastPageFooter());
        this.visitBand(report.getSummary());
        this.visitBand(report.getNoData());
        JRGroup[] groups = report.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                JRGroup group = groups[i];
                this.visitSection(group.getGroupHeaderSection());
                this.visitSection(group.getGroupFooterSection());
            }
        }
    }

    protected void visitSection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null) {
            for (int i = 0; i < bands.length; ++i) {
                this.visitBand(bands[i]);
            }
        }
    }

    protected void visitBand(JRBand band) {
        if (band != null) {
            band.visit(this);
        }
    }

    protected void visitElements(List elements) {
        if (elements != null) {
            for (JRChild child : elements) {
                child.visit(this);
            }
        }
    }

    @Override
    public void visitElementGroup(JRElementGroup elementGroup) {
        super.visitElementGroup(elementGroup);
        this.visitElements(elementGroup.getChildren());
    }

    @Override
    public void visitFrame(JRFrame frame) {
        super.visitFrame(frame);
        this.visitElements(frame.getChildren());
    }

    @Override
    public void visitCrosstab(JRCrosstab crosstab) {
        block6: {
            block5: {
                super.visitCrosstab(crosstab);
                this.visitCrosstabCell(crosstab.getWhenNoDataCell());
                this.visitCrosstabCell(crosstab.getHeaderCell());
                JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
                for (int i = 0; i < rowGroups.length; ++i) {
                    JRCrosstabRowGroup rowGroup = rowGroups[i];
                    this.visitCrosstabCell(rowGroup.getHeader());
                    this.visitCrosstabCell(rowGroup.getTotalHeader());
                }
                JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
                for (int i = 0; i < columnGroups.length; ++i) {
                    JRCrosstabColumnGroup columnGroup = columnGroups[i];
                    this.visitCrosstabCell(columnGroup.getHeader());
                    this.visitCrosstabCell(columnGroup.getTotalHeader());
                }
                if (!(crosstab instanceof JRDesignCrosstab)) break block5;
                List cells = ((JRDesignCrosstab)crosstab).getCellsList();
                for (JRCrosstabCell cell : cells) {
                    this.visitCrosstabCell(cell.getContents());
                }
                break block6;
            }
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells == null) break block6;
            HashSet<JRCellContents> cellContents = new HashSet<JRCellContents>();
            for (int i = 0; i < cells.length; ++i) {
                for (int j = 0; j < cells[i].length; ++j) {
                    JRCrosstabCell cell = cells[i][j];
                    if (cell == null || cell.getContents() == null || !cellContents.add(cell.getContents())) continue;
                    this.visitCrosstabCell(cell.getContents());
                }
            }
        }
    }

    protected void visitCrosstabCell(JRCellContents cell) {
        if (cell != null) {
            this.visitElements(cell.getChildren());
        }
    }
}

