/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRAbstractImageEncoder;

public class JRJdk14ImageEncoder
extends JRAbstractImageEncoder {
    @Override
    public byte[] encode(BufferedImage bi, byte imageType) throws JRException {
        String formatName = null;
        switch (imageType) {
            case 1: {
                formatName = "gif";
                break;
            }
            case 3: {
                formatName = "png";
                break;
            }
            case 4: {
                formatName = "tiff";
                break;
            }
            default: {
                formatName = "jpeg";
            }
        }
        boolean success = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            success = ImageIO.write((RenderedImage)bi, formatName, baos);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (!success) {
            throw new JRException("No appropriate image writer found for the \"" + formatName + "\" format.");
        }
        return baos.toByteArray();
    }
}

