/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;

public class JRProperties {
    protected static final String DEFAULT_PROPERTIES_FILE = "jasperreports.properties";
    public static final String PROPERTY_PREFIX = "net.sf.jasperreports.";
    public static final String PROPERTIES_FILE = "net.sf.jasperreports.properties";
    public static final String COMPILER_CLASS = "net.sf.jasperreports.compiler.class";
    public static final String COMPILER_XML_VALIDATION = "net.sf.jasperreports.compiler.xml.validation";
    public static final String COMPILER_KEEP_JAVA_FILE = "net.sf.jasperreports.compiler.keep.java.file";
    public static final String COMPILER_TEMP_DIR = "net.sf.jasperreports.compiler.temp.dir";
    public static final String COMPILER_CLASSPATH = "net.sf.jasperreports.compiler.classpath";
    public static final String EXPORT_XML_VALIDATION = "net.sf.jasperreports.export.xml.validation";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String QUERY_EXECUTER_FACTORY_PREFIX = "net.sf.jasperreports.query.executer.factory.";
    public static final String SUBREPORT_RUNNER_FACTORY = "net.sf.jasperreports.subreport.runner.factory";
    public static final String PDF_FORCE_LINEBREAK_POLICY = "net.sf.jasperreports.export.pdf.force.linebreak.policy";
    protected static Properties props;
    protected static Properties savedProps;

    protected static void initProperties() {
        try {
            Properties defaults = JRProperties.getDefaults();
            String propFile = JRProperties.getSystemProperty(PROPERTIES_FILE);
            if (propFile == null) {
                props = JRProperties.loadProperties(DEFAULT_PROPERTIES_FILE, defaults);
                if (props == null) {
                    props = new Properties(defaults);
                }
            } else {
                props = JRProperties.loadProperties(propFile, defaults);
                if (props == null) {
                    throw new JRRuntimeException("Could not load properties file \"" + propFile + "\"");
                }
            }
            JRProperties.loadSystemProperties();
        }
        catch (JRException e) {
            throw new JRRuntimeException("Error loading the properties", e);
        }
    }

    protected static void loadSystemProperties() {
        JRProperties.loadSystemProperty("jasper.reports.compiler.class", COMPILER_CLASS);
        JRProperties.loadSystemProperty("jasper.reports.compile.xml.validation", COMPILER_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.export.xml.validation", EXPORT_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.compile.keep.java.file", COMPILER_KEEP_JAVA_FILE);
        JRProperties.loadSystemProperty("jasper.reports.compile.temp", COMPILER_TEMP_DIR);
        JRProperties.loadSystemProperty("jasper.reports.compile.class.path", COMPILER_CLASSPATH);
    }

    protected static Properties getDefaults() throws JRException {
        String classPath;
        Properties defaults = new Properties();
        InputStream is = JRProperties.class.getResourceAsStream("/default.jasperreports.properties");
        if (is == null) {
            throw new JRException("Default properties file not found.");
        }
        try {
            defaults.load(is);
        }
        catch (IOException e) {
            throw new JRException("Failed to load default properties.", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        String userDir = JRProperties.getSystemProperty("user.dir");
        if (userDir != null) {
            defaults.setProperty(COMPILER_TEMP_DIR, userDir);
        }
        if ((classPath = JRProperties.getSystemProperty("java.class.path")) != null) {
            defaults.setProperty(COMPILER_CLASSPATH, classPath);
        }
        return defaults;
    }

    protected static String getSystemProperty(String propertyName) {
        try {
            return System.getProperty(propertyName);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected static void loadSystemProperty(String sysKey, String propKey) {
        String val = JRProperties.getSystemProperty(sysKey);
        if (val != null) {
            props.setProperty(propKey, val);
        }
    }

    public static Properties loadProperties(String name, Properties defaults) throws JRException {
        Properties properties = null;
        InputStream is = null;
        try {
            is = JRLoader.getLocationInputStream(name);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (is != null) {
            properties = new Properties(defaults);
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new JRException("Failed to load properties file \"" + name + "\"", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static boolean getBooleanProperty(String key) {
        return JRProperties.asBoolean(props.getProperty(key));
    }

    public static int getIntegerProperty(String key) {
        return JRProperties.asInteger(props.getProperty(key));
    }

    public static float getFloatProperty(String key) {
        return JRProperties.asFloat(props.getProperty(key));
    }

    public static boolean asBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static int asInteger(String value) {
        return Integer.parseInt(value);
    }

    public static float asFloat(String value) {
        return Float.parseFloat(value);
    }

    public static void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public static void setProperty(String key, boolean value) {
        props.setProperty(key, String.valueOf(value));
    }

    public static void removePropertyValue(String key) {
        props.remove(key);
    }

    public static void backupProperties() {
        savedProps = (Properties)props.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreProperties() {
        if (savedProps != null) {
            try {
                props.clear();
                props.putAll((Map<?, ?>)savedProps);
            }
            finally {
                savedProps = null;
            }
        }
    }

    public static List getProperties(String prefix) {
        int prefixLength = prefix.length();
        ArrayList<PropertySuffix> values = new ArrayList<PropertySuffix>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix)) continue;
            String suffix = name.substring(prefixLength);
            String value = props.getProperty(name);
            values.add(new PropertySuffix(name, suffix, value));
        }
        return values;
    }

    public static List getProperties(JRPropertiesHolder propertiesHolder, String prefix) {
        return JRProperties.getProperties(JRProperties.getOwnProperties(propertiesHolder), prefix);
    }

    public static List getAllProperties(JRPropertiesHolder propertiesHolder, String prefix) {
        return JRProperties.getAllProperties(JRProperties.getOwnProperties(propertiesHolder), prefix);
    }

    public static List getProperties(JRPropertiesMap propertiesMap, String prefix) {
        int prefixLength = prefix.length();
        ArrayList<PropertySuffix> values = new ArrayList<PropertySuffix>();
        if (propertiesMap != null) {
            String[] propertyNames = propertiesMap.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                if (!name.startsWith(prefix)) continue;
                String suffix = name.substring(prefixLength);
                String value = propertiesMap.getProperty(name);
                values.add(new PropertySuffix(name, suffix, value));
            }
        }
        return values;
    }

    public static List getAllProperties(JRPropertiesMap propertiesMap, String prefix) {
        List collected;
        List own = JRProperties.getProperties(propertiesMap, prefix);
        List global = JRProperties.getProperties(prefix);
        if (own.isEmpty()) {
            collected = global;
        } else {
            if (!global.isEmpty()) {
                HashSet<String> ownSuffixes = new HashSet<String>();
                for (PropertySuffix prop : own) {
                    ownSuffixes.add(prop.getSuffix());
                }
                for (PropertySuffix prop : global) {
                    if (ownSuffixes.contains(prop.getSuffix())) continue;
                    own.add(prop);
                }
            }
            collected = own;
        }
        return collected;
    }

    public static String getProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = null;
        while (propertiesHolder != null && value == null) {
            if (propertiesHolder.hasProperties()) {
                value = propertiesHolder.getPropertiesMap().getProperty(key);
            }
            propertiesHolder = propertiesHolder.getParentProperties();
        }
        if (value == null) {
            value = props.getProperty(key);
        }
        return value;
    }

    public static String getProperty(JRPropertiesMap propertiesMap, String key) {
        String value = null;
        if (propertiesMap != null) {
            value = propertiesMap.getProperty(key);
        }
        if (value == null) {
            value = props.getProperty(key);
        }
        return value;
    }

    public static boolean getBooleanProperty(JRPropertiesHolder propertiesHolder, String key, boolean defaultValue) {
        String value = JRProperties.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRProperties.asBoolean(value);
    }

    public static boolean getBooleanProperty(JRPropertiesMap propertiesMap, String key, boolean defaultValue) {
        String value = JRProperties.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRProperties.asBoolean(value);
    }

    public static int getIntegerProperty(JRPropertiesHolder propertiesHolder, String key, int defaultValue) {
        String value = JRProperties.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRProperties.asInteger(value);
    }

    public static int getIntegerProperty(JRPropertiesMap propertiesMap, String key, int defaultValue) {
        String value = JRProperties.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRProperties.asInteger(value);
    }

    public static int getIntegerProperty(String key, int defaultValue) {
        String value = JRProperties.getProperty(key);
        return value == null ? defaultValue : JRProperties.asInteger(value);
    }

    public static float getFloatProperty(JRPropertiesHolder propertiesHolder, String key, float defaultValue) {
        String value = JRProperties.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRProperties.asFloat(value);
    }

    public static float getFloatProperty(JRPropertiesMap propertiesMap, String key, float defaultValue) {
        String value = JRProperties.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRProperties.asFloat(value);
    }

    public static float getFloatProperty(String key, float defaultValue) {
        String value = JRProperties.getProperty(key);
        return value == null ? defaultValue : JRProperties.asFloat(value);
    }

    public static long asLong(String value) {
        return Long.parseLong(value);
    }

    public static long getLongProperty(String key) {
        return JRProperties.asLong(props.getProperty(key));
    }

    public static long getLongProperty(JRPropertiesMap propertiesMap, String key, int defaultValue) {
        String value = JRProperties.getProperty(propertiesMap, key);
        return value == null ? (long)defaultValue : JRProperties.asLong(value);
    }

    public static long getLongProperty(JRPropertiesHolder propertiesHolder, String key, int defaultValue) {
        String value = JRProperties.getProperty(propertiesHolder, key);
        return value == null ? (long)defaultValue : JRProperties.asLong(value);
    }

    protected static JRPropertiesMap getOwnProperties(JRPropertiesHolder propertiesHolder) {
        return propertiesHolder.hasProperties() ? propertiesHolder.getPropertiesMap() : null;
    }

    public static void transferProperties(JRPropertiesHolder source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        if (!source.hasProperties()) {
            return;
        }
        JRProperties.transfer(source.getPropertiesMap(), destination, tranferPropertiesPrefix);
    }

    public static void transferProperties(JRPropertiesMap source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        if (source == null || !source.hasProperties()) {
            return;
        }
        JRProperties.transfer(source, destination, tranferPropertiesPrefix);
    }

    protected static void transfer(JRPropertiesMap source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        List transferPrefixProps = JRProperties.getProperties(tranferPropertiesPrefix);
        for (PropertySuffix transferPrefixProp : transferPrefixProps) {
            String transferPrefix = transferPrefixProp.getValue();
            if (transferPrefix == null || transferPrefix.length() <= 0) continue;
            List transferProps = JRProperties.getProperties(source, transferPrefix);
            for (PropertySuffix property : transferProps) {
                String value = property.getValue();
                destination.getPropertiesMap().setProperty(property.getKey(), value);
            }
        }
    }

    public static Character getCharacterProperty(String key) {
        return JRProperties.asCharacter(props.getProperty(key));
    }

    public static Character getCharacterProperty(JRPropertiesMap propertiesMap, String key) {
        String value = JRProperties.getProperty(propertiesMap, key);
        return JRProperties.asCharacter(value);
    }

    public static Character asCharacter(String value) {
        return value == null || value.length() == 0 ? null : new Character(value.charAt(0));
    }

    static {
        JRProperties.initProperties();
    }

    public static class PropertySuffix {
        protected final String key;
        protected final String suffix;
        protected final String value;

        public PropertySuffix(String key, String suffix, String value) {
            this.key = key;
            this.suffix = suffix;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getValue() {
            return this.value;
        }
    }
}

